/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.olc;

import tim.prune.data.DataPoint;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.olc.CoordPair;
import tim.prune.function.olc.OlcArea;
import tim.prune.function.olc.ParseException;

public class OlcDecoder {
    public static OlcArea decode(String string, double d, double d2) {
        if (OlcDecoder.isValidLongForm(string)) {
            return OlcDecoder.decode(string);
        }
        if (!OlcDecoder.isValidShortForm(string)) {
            return null;
        }
        return OlcDecoder.findBestArea(string, d, d2);
    }

    public static boolean isValidLongForm(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(43);
        return string.indexOf(32) < 0 && string.indexOf(44) < 0 && (string.length() == 8 && n < 0 || string.length() > 8 && n == 8);
    }

    public static boolean isValidShortForm(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(43);
        return string.indexOf(32) < 0 && string.indexOf(44) < 0 && string.length() <= 8 && n == 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OlcArea decode(String string) {
        if (!OlcDecoder.isValidLongForm(string)) {
            return null;
        }
        String string2 = string.trim().toUpperCase();
        if (string2.length() < 8 || string2.length() > 12) {
            return null;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 400.0;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            while (true) {
                CoordPair coordPair;
                if (n >= string.length()) {
                    if (n2 >= true) break;
                    return null;
                }
                if (n == 0 || n == 2 || n == 4 || n == 6 || n == 9) {
                    coordPair = CoordPair.decode(string2.charAt(n), string2.charAt(n + 1));
                    if (coordPair == CoordPair.PADDING) {
                        bl = true;
                    } else {
                        if (bl) {
                            return null;
                        }
                        d += coordPair.lat * d3;
                        d2 += coordPair.lon * d3;
                        ++n2;
                        d3 /= 20.0;
                    }
                    n += 2;
                    continue;
                }
                if (n == 8) {
                    if (string2.charAt(n) != '+') {
                        return null;
                    }
                    ++n;
                    continue;
                }
                if (n != 11) {
                    return null;
                }
                coordPair = CoordPair.decode(string2.charAt(n));
                d += coordPair.lat * d3;
                d2 += coordPair.lon * d3;
                ++n;
                ++n2;
                d3 /= 20.0;
            }
            d -= 90.0;
            d2 -= 180.0;
            if (n2 < 6) {
                return new OlcArea(d, d2, d + d3, d2 + d3, string);
            }
            return new OlcArea(d, d2, d, d2, string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static OlcArea findBestArea(String string, double d, double d2) {
        double d3 = (d + 90.0) / 20.0;
        int n = (int)Math.floor(d3);
        int n2 = (int)Math.floor((d3 - (double)n) * 20.0);
        double d4 = (d2 + 180.0) % 360.0 / 20.0;
        int n3 = (int)Math.floor(d4);
        int n4 = (int)Math.floor((d4 - (double)n3) * 20.0);
        DataPoint dataPoint = new DataPoint(new Latitude(d, 12), new Longitude(d2, 12), null);
        OlcArea olcArea = null;
        double d5 = 0.0;
        int n5 = -1;
        while (n5 <= 1) {
            int n6 = -1;
            while (n6 <= 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(CoordPair.encode(n + OlcDecoder.getDelta(n2, n5)));
                stringBuilder.append(CoordPair.encode(n3 + OlcDecoder.getDelta(n4, n6)));
                stringBuilder.append(CoordPair.encode(n2 + n5));
                stringBuilder.append(CoordPair.encode(n4 + n6));
                stringBuilder.append(string);
                OlcArea olcArea2 = OlcDecoder.decode(stringBuilder.toString());
                double d6 = OlcDecoder.calcDistance(olcArea2, dataPoint);
                if (olcArea == null || d6 < d5) {
                    olcArea = olcArea2;
                    d5 = d6;
                }
                ++n6;
            }
            ++n5;
        }
        return olcArea;
    }

    private static int getDelta(int n, int n2) {
        if (n == 0 && n2 < 0) {
            return -1;
        }
        if (n == 19 && n2 > 0) {
            return 1;
        }
        return 0;
    }

    private static double calcDistance(OlcArea olcArea, DataPoint dataPoint) {
        DataPoint dataPoint2 = new DataPoint(new Latitude(olcArea.middleLat(), 12), new Longitude(olcArea.middleLon(), 12), null);
        return DataPoint.calculateRadiansBetween(dataPoint2, dataPoint);
    }
}

