/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBRecord;
import db.Field;
import db.Schema;
import ghidra.util.ObjectStorage;
import ghidra.util.Saveable;
import javax.help.UnsupportedOperationException;

public class GenericSaveable
implements Saveable {
    final DBRecord record;
    final Schema schema;
    final Class<?>[] fieldClasses = new Class[0];

    GenericSaveable(DBRecord record, Schema schema) {
        this.record = record;
        this.schema = schema;
    }

    public Class<?>[] getObjectStorageFields() {
        return this.fieldClasses;
    }

    public void save(ObjectStorage objStorage) {
        throw new UnsupportedOperationException("not supported by GenericSaveable");
    }

    public void restore(ObjectStorage objStorage) {
        throw new UnsupportedOperationException("not supported by GenericSaveable");
    }

    public int getSchemaVersion() {
        return 0;
    }

    public boolean isUpgradeable(int oldSchemaVersion) {
        return false;
    }

    public boolean upgrade(ObjectStorage oldObjStorage, int oldSchemaVersion, ObjectStorage currentObjStorage) {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.record == null ? 0 : this.record.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericSaveable other = (GenericSaveable)obj;
        return !(this.record == null ? other.record != null : !this.record.equals((Object)other.record));
    }

    public String toString() {
        if (this.record == null || this.schema == null) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer();
        String[] fieldNames = this.schema.getFieldNames();
        int numFields = fieldNames.length;
        for (int i = 0; i < numFields; ++i) {
            Field field = this.record.getFieldValue(i);
            buf.append("\n" + fieldNames[i] + "=" + field.toString() + " ");
        }
        buf.append("\n");
        return buf.toString();
    }
}

