/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.languages.sleigh;

import ghidra.app.plugin.languages.sleigh.ConstructorEntryVisitor;
import ghidra.app.plugin.languages.sleigh.PcodeOpEntryVisitor;
import ghidra.app.plugin.languages.sleigh.SleighConstructorTraversal;
import ghidra.app.plugin.languages.sleigh.SleighPcodeTraversal;
import ghidra.app.plugin.languages.sleigh.SleighSubtableTraversal;
import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import java.util.concurrent.atomic.AtomicBoolean;

public class SleighLanguages {
    public static int traverseConstructors(SleighLanguage lang, ConstructorEntryVisitor visitor) {
        return new SleighConstructorTraversal(lang).traverse(visitor);
    }

    public static int traverseConstructors(SubtableSymbol subtable, SubtableEntryVisitor visitor) {
        return new SleighSubtableTraversal(subtable).traverse(visitor);
    }

    public static int traverseAllPcodeOps(SleighLanguage lang, PcodeOpEntryVisitor visitor) {
        return SleighLanguages.traverseConstructors(lang, new ConsVisitForPcode(visitor));
    }

    protected static class ConsVisitForPcode
    implements ConstructorEntryVisitor {
        protected final PcodeOpEntryVisitor visitor;

        public ConsVisitForPcode(PcodeOpEntryVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public int visit(final SubtableSymbol subtable, final DisjointPattern pattern, final Constructor cons) {
            final AtomicBoolean atLeastOne = new AtomicBoolean(false);
            int result = new SleighPcodeTraversal(cons).traverse(new SleighPcodeTraversal.OnlyPcodeOpEntryVisitor(){

                @Override
                public int visit(OpTpl op) {
                    atLeastOne.set(true);
                    return visitor.visit(subtable, pattern, cons, op);
                }
            });
            if (!atLeastOne.get()) {
                this.visitor.visit(subtable, pattern, cons, null);
            }
            if (result != 1) {
                assert (result != 0);
                return 2;
            }
            return 0;
        }
    }
}

