/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.AbstractMapEntry;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapProposal;
import ghidra.debug.api.modules.SectionMapProposal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import java.util.Map;

public class DefaultSectionMapProposal
extends AbstractMapProposal<TraceSection, MemoryBlock, SectionMapProposal.SectionMapEntry>
implements SectionMapProposal {
    protected final TraceModule module;
    protected final long snap;
    protected final SectionMatcherMap matchers;

    protected DefaultSectionMapProposal(TraceModule module, long snap, Program program) {
        super(module.getTrace(), program);
        this.module = module;
        this.snap = snap;
        this.matchers = new SectionMatcherMap(snap);
        this.processModule();
        this.processProgram();
    }

    protected DefaultSectionMapProposal(TraceSection section, long snap, Program program, MemoryBlock block) {
        super(section.getTrace(), program);
        this.module = section.getModule();
        this.snap = snap;
        this.matchers = new SectionMatcherMap(snap);
        this.matchers.processFromObject(section);
        this.matchers.processToObject(block);
    }

    public TraceModule getModule() {
        return this.module;
    }

    private void processModule() {
        for (TraceSection section : this.module.getSections(this.snap)) {
            this.matchers.processFromObject(section);
        }
    }

    private void processProgram() {
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            this.matchers.processToObject(block);
        }
    }

    public double computeScore() {
        return this.matchers.averageScore();
    }

    public Map<TraceSection, SectionMapProposal.SectionMapEntry> computeMap() {
        return this.matchers.computeMap(m -> new DefaultSectionMapEntry((TraceSection)m.fromObject, this.snap, this.program, (MemoryBlock)m.toObject));
    }

    public MemoryBlock getToObject(TraceSection from) {
        return (MemoryBlock)this.matchers.getToObject(from);
    }

    protected static class SectionMatcherMap
    extends AbstractMapProposal.MatcherMap<String, TraceSection, MemoryBlock, SectionMatcher> {
        public SectionMatcherMap(long snap) {
            super(snap);
        }

        @Override
        protected SectionMatcher newMatcher(TraceSection section, MemoryBlock block) {
            return new SectionMatcher(section, this.snap, block);
        }

        @Override
        protected String getFromJoinKey(TraceSection section) {
            return section.getName(this.snap);
        }

        @Override
        protected String getToJoinKey(MemoryBlock block) {
            return block.getName();
        }
    }

    public static class DefaultSectionMapEntry
    extends AbstractMapEntry<TraceSection, MemoryBlock>
    implements SectionMapProposal.SectionMapEntry {
        protected DefaultSectionMapEntry(TraceSection section, long snap, Program program, MemoryBlock block) {
            super(section.getTrace(), section, snap, program, block);
        }

        public TraceModule getModule() {
            return ((TraceSection)this.getFromObject()).getModule();
        }

        public String getModuleName() {
            return this.getModule().getName(this.snap);
        }

        public TraceSection getSection() {
            return (TraceSection)this.getFromObject();
        }

        public String getSectionName() {
            return this.getSection().getName(this.snap);
        }

        public Address getSectionStart() {
            return this.getSection().getStart(this.snap);
        }

        public AddressRange getFromRange() {
            return this.getSection().getRange(this.snap);
        }

        public MemoryBlock getBlock() {
            return (MemoryBlock)this.getToObject();
        }

        public AddressRange getToRange() {
            return new AddressRangeImpl(this.getBlock().getStart(), this.getBlock().getEnd());
        }

        public void setBlock(Program program, MemoryBlock block) {
            this.setToObject(program, block);
        }
    }

    protected static class SectionMatcher
    extends AbstractMapProposal.Matcher<TraceSection, MemoryBlock> {
        public SectionMatcher(TraceSection section, long snap, MemoryBlock block) {
            super(section, snap, block);
        }

        @Override
        protected AddressRange getFromRange() {
            return this.fromObject == null ? null : ((TraceSection)this.fromObject).getRange(this.snap);
        }

        @Override
        protected AddressRange getToRange() {
            return this.toObject == null ? null : new AddressRangeImpl(((MemoryBlock)this.toObject).getStart(), ((MemoryBlock)this.toObject).getEnd());
        }
    }
}

