/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExceptionStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_EXCEPTION";
    public static final int EXCEPTION_MAXIMUM_PARAMETERS = 15;
    private int threadId;
    private int exceptionCode;
    private int exceptionFlags;
    private long exceptionRecord;
    private long exceptionAddress;
    private int numberOfParameters;
    private long[] exceptionInformation;
    private int contextDataSize;
    private int contextRVA;
    private StructureDataType defaultContext;
    private String[] keys1 = new String[]{"ContextFlags", "DR0", "DR1", "DR2", "DR3", "DR6", "DR7"};
    private String[] keys2 = new String[]{"GS", "FS", "ES", "DS", "EDI", "ESI", "EBX", "EDX", "ECX", "EAX", "EBP", "EIP", "CS", "eflags", "ESP", "SS"};
    private DumpFileReader reader;
    private long index;

    ExceptionStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
        this.getRVAs();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setThreadId(this.reader.readNextInt());
        this.reader.readNextInt();
        this.setExceptionCode(this.reader.readNextInt());
        this.setExceptionFlags(this.reader.readNextInt());
        this.setExceptionRecord(this.reader.readNextLong());
        this.setExceptionAddress(this.reader.readNextLong());
        this.setNumberOfParameters(this.reader.readNextInt());
        this.reader.readNextInt();
        this.exceptionInformation = new long[15];
        for (int i = 0; i < 15; ++i) {
            this.setExceptionInformation(this.reader.readNextLong(), i);
        }
        this.setContextDataSize(this.reader.readNextInt());
        this.setContextRVA(this.reader.readNextInt());
    }

    private void getRVAs() {
        int i;
        long pos = this.reader.getPointerIndex();
        this.reader.setPointerIndex(this.getContextRVA());
        this.defaultContext = new StructureDataType("ExceptionContext_" + Integer.toHexString(this.threadId), 0);
        for (i = 0; i < 7; ++i) {
            this.defaultContext.add(DWORD, this.keys1[i], null);
        }
        for (i = 7; i < 35; ++i) {
            this.defaultContext.add(DWORD, "", null);
        }
        for (i = 35; i < 51; ++i) {
            this.defaultContext.add(DWORD, this.keys2[i - 35], null);
        }
        for (i = 51; i < 179 && i < this.getContextDataSize() / 4; ++i) {
            this.defaultContext.add(DWORD, "", null);
        }
        this.reader.setPointerIndex(pos);
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "ThreadId", null);
        StructureDataType s0 = new StructureDataType("ExceptionRecord", 0);
        s0.add(DWORD, 4, "__alignment", null);
        s0.add(DWORD, 4, "ExceptionCode", null);
        s0.add(DWORD, 4, "ExceptionFlags", null);
        s0.add(QWORD, 8, "ExceptionRecord", null);
        s0.add(QWORD, 8, "ExceptionAddress", null);
        s0.add(DWORD, 4, "NumberParameters", null);
        s0.add(DWORD, 4, "__unusedAlignment", null);
        ArrayDataType a = new ArrayDataType(QWORD, 15, 8);
        s0.add((DataType)a, a.getLength(), "ExceptionInformation", null);
        StructureDataType s1 = new StructureDataType("ThreadContext", 0);
        s1.add(DWORD, 4, "DataSize", null);
        s1.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        struct.add((DataType)s0, s0.getLength(), s0.getDisplayName(), null);
        struct.add((DataType)s1, s1.getLength(), s1.getDisplayName(), null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public int getExceptionFlags() {
        return this.exceptionFlags;
    }

    public void setExceptionFlags(int exceptionFlags) {
        this.exceptionFlags = exceptionFlags;
    }

    public long getExceptionRecord() {
        return this.exceptionRecord;
    }

    public void setExceptionRecord(long exceptionRecord) {
        this.exceptionRecord = exceptionRecord;
    }

    public long getExceptionAddress() {
        return this.exceptionAddress;
    }

    public void setExceptionAddress(long exceptionAddress) {
        this.exceptionAddress = exceptionAddress;
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public void setNumberOfParameters(int numberOfParameters) {
        this.numberOfParameters = numberOfParameters;
    }

    public long getExceptionInformation(int idx) {
        return this.exceptionInformation[idx];
    }

    public void setExceptionInformation(long exceptionInformation, int index) {
        this.exceptionInformation[index] = exceptionInformation;
    }

    public void setContextDataSize(int contextDataSize) {
        this.contextDataSize = contextDataSize;
    }

    public int getContextDataSize() {
        return this.contextDataSize;
    }

    public void setContextRVA(int contextRVA) {
        this.contextRVA = contextRVA;
    }

    public int getContextRVA() {
        return this.contextRVA;
    }

    public StructureDataType getDefaultContext() {
        return this.defaultContext;
    }
}

