/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public final class ModifiedUTF8 {
    public static final String decode(InputStream in, char[] out) throws UTFDataFormatException, IOException {
        int s = 0;
        while (true) {
            int b;
            char a;
            if ((a = (char)(in.read() & 0xFF)) == '\u0000') {
                return new String(out, 0, s);
            }
            out[s] = a;
            if (a < '\u0080') {
                ++s;
                continue;
            }
            if ((a & 0xE0) == 192) {
                b = in.read() & 0xFF;
                if ((b & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) != 224) break;
            b = in.read() & 0xFF;
            int c = in.read() & 0xFF;
            if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }
}

