/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.reader;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import mobiledevices.dmg.decmpfs.DecmpfsHeader;
import mobiledevices.dmg.hfsplus.AttributesFileParser;
import mobiledevices.dmg.reader.DmgFileReader;
import org.catacombae.hfsexplorer.ObjectContainer;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.FSFork;
import org.catacombae.jparted.lib.fs.FSLink;
import org.catacombae.jparted.lib.fs.WindowsFileAttributes;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFSFile;

class DmgInfoGenerator {
    private DmgFileReader fileSystem;
    private String filePath;
    private AttributesFileParser parser;
    private FSEntry entry;
    private DateFormat df = DateFormat.getDateTimeInstance(3, 2);

    DmgInfoGenerator(DmgFileReader fileSystem, String filePath, AttributesFileParser parser) {
        this.fileSystem = fileSystem;
        this.filePath = filePath;
        this.parser = parser;
        this.entry = fileSystem.getFileByPath(filePath);
    }

    List<String> getInformation() {
        ArrayList<String> infoList = new ArrayList<String>();
        if (this.entry == null) {
            infoList.add("<< no information available >>");
            return infoList;
        }
        infoList.add("Name: " + this.entry.getName());
        if (this.entry instanceof FSFile) {
            FSFork[] allForks;
            FSFile file = (FSFile)this.entry;
            infoList.add("Type: File");
            infoList.add("Total Size: " + this.getSizeString(file.getCombinedLength()));
            for (FSFork fork : allForks = file.getAllForks()) {
                infoList.add("    " + fork.getForkIdentifier() + ": " + this.getSizeString(fork.getLength()));
            }
            this.appendFileID(infoList, file);
            if (this.parser != null) {
                try {
                    DecmpfsHeader decmpfsHeader = this.parser.getDecmpfsHeader(file);
                    if (decmpfsHeader != null) {
                        infoList.add("Decmpfs Size: " + this.getSizeString(decmpfsHeader.getUncompressedSize()));
                    }
                }
                catch (IOException decmpfsHeader) {}
            }
        } else if (this.entry instanceof FSFolder) {
            FSFolder folder = (FSFolder)this.entry;
            infoList.add("Type: Folder");
            infoList.add("Size: " + this.startFolderSizeCalculation(folder));
        } else if (this.entry instanceof FSLink) {
            FSLink link = (FSLink)this.entry;
            FSEntry linkTarget = link.getLinkTarget(this.fileSystem.convertPathToArrayAndStripFileSystemName(this.filePath));
            if (linkTarget == null) {
                infoList.add("Type: Symbolic link (broken)");
                infoList.add("Size: - (broken link)");
            } else if (linkTarget instanceof FSFile) {
                FSFork[] allForks;
                FSFile file = (FSFile)linkTarget;
                infoList.add("Type: Symbolic link (file)");
                infoList.add("Size: " + this.getSizeString(file.getMainFork().getLength()));
                for (FSFork fork : allForks = file.getAllForks()) {
                    infoList.add("    " + fork.getForkIdentifier() + ": " + this.getSizeString(fork.getLength()));
                }
            } else if (linkTarget instanceof FSFolder) {
                FSFolder folder = (FSFolder)linkTarget;
                infoList.add("Type: Symbolic link (folder)");
                infoList.add("Size: " + this.startFolderSizeCalculation(folder));
            } else {
                infoList.add("Type: Symbolic link (unknown [" + String.valueOf(linkTarget.getClass()) + "])");
                infoList.add("Size: - (unknown type)");
            }
            infoList.add("Link Target: " + link.getLinkTargetString());
        } else {
            infoList.add("Type: Unknown [" + String.valueOf(this.entry.getClass()) + "]");
            infoList.add("Size: - (unknown size)");
        }
        FSAttributes attrs = this.entry.getAttributes();
        this.appendDateInformation(attrs, infoList);
        this.appendPosixInformation(attrs, infoList);
        this.appendWindowsInformation(attrs, infoList);
        return infoList;
    }

    private void appendFileID(List<String> infoList, FSFile file) {
        try {
            HFSCommonFSFile hfsFile = (HFSCommonFSFile)file;
            CommonHFSCatalogFile catalogFile = hfsFile.getInternalCatalogFile();
            CommonHFSCatalogFile.HFSPlusImplementation hfsPlusCatalogFile = (CommonHFSCatalogFile.HFSPlusImplementation)catalogFile;
            HFSPlusCatalogFile underlying = hfsPlusCatalogFile.getUnderlying();
            HFSCatalogNodeID fileID = underlying.getFileID();
            infoList.add("File ID: 0x" + Integer.toHexString(fileID.toInt()));
        }
        catch (Exception e) {
            infoList.add("Unable to obtain file ID. " + e.getMessage());
        }
    }

    private void appendPosixInformation(FSAttributes attrs, List<String> infoList) {
        if (attrs.hasPOSIXFileAttributes()) {
            FSAttributes.POSIXFileAttributes posixAttrs = attrs.getPOSIXFileAttributes();
            infoList.add("Permissions: " + posixAttrs.getPermissionString());
            infoList.add("User ID:     " + posixAttrs.getUserID());
            infoList.add("Group ID:    " + posixAttrs.getGroupID());
        }
    }

    private void appendWindowsInformation(FSAttributes attrs, List<String> infoList) {
        if (attrs.hasWindowsFileAttributes()) {
            WindowsFileAttributes windowsFileAttributes = attrs.getWindowsFileAttributes();
            infoList.add("Archive:    " + windowsFileAttributes.isArchive());
            infoList.add("Compressed: " + windowsFileAttributes.isCompressed());
            infoList.add("Directory:  " + windowsFileAttributes.isDirectory());
            infoList.add("Encrypted:  " + windowsFileAttributes.isEncrypted());
            infoList.add("Hidden:     " + windowsFileAttributes.isHidden());
            infoList.add("Normal:     " + windowsFileAttributes.isNormal());
            infoList.add("Off-line:   " + windowsFileAttributes.isOffline());
            infoList.add("Read-only:  " + windowsFileAttributes.isReadOnly());
            infoList.add("Reparse:    " + windowsFileAttributes.isReparsePoint());
            infoList.add("Sparse:     " + windowsFileAttributes.isSparseFile());
            infoList.add("System:     " + windowsFileAttributes.isSystem());
            infoList.add("Temp:       " + windowsFileAttributes.isTemporary());
            infoList.add("Virtual:    " + windowsFileAttributes.isVirtual());
        }
    }

    private void appendDateInformation(FSAttributes attributes, List<String> infoList) {
        if (attributes.hasCreateDate()) {
            infoList.add("Created: " + this.df.format(attributes.getCreateDate()));
        }
        if (attributes.hasModifyDate()) {
            infoList.add("Contents Modified: " + this.df.format(attributes.getModifyDate()));
        }
        if (attributes.hasAttributeModifyDate()) {
            infoList.add("Attributes Modified: " + this.df.format(attributes.getAttributeModifyDate()));
        }
        if (attributes.hasAccessDate()) {
            infoList.add("Last Accessed: " + this.df.format(attributes.getAccessDate()));
        }
        if (attributes.hasBackupDate()) {
            infoList.add("Last Backup: " + this.df.format(attributes.getBackupDate()));
        }
    }

    private String getSizeString(long result) {
        String baseString = Long.toString(result);
        return baseString + " bytes";
    }

    private String startFolderSizeCalculation(FSFolder folder) {
        String resultString;
        try {
            ObjectContainer result = new ObjectContainer((Object)0L);
            this.calculateFolderSize(folder, (ObjectContainer<Long>)result);
            resultString = this.getSizeString((Long)result.o);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultString = "Exception while calculating! See debug console for info...";
        }
        return resultString;
    }

    private void calculateFolderSize(FSFolder folder, ObjectContainer<Long> result) {
        for (FSEntry entry : folder.listEntries()) {
            if (entry instanceof FSFile) {
                Long value = (Long)result.o;
                value = value + ((FSFile)entry).getMainFork().getLength();
                result.o = value;
                continue;
            }
            if (entry instanceof FSFolder) {
                this.calculateFolderSize((FSFolder)entry, result);
                continue;
            }
            if (entry instanceof FSLink) continue;
            System.err.println("FSEntrySummaryPanel.calculateFolderSize(): unexpected type " + String.valueOf(entry.getClass()));
        }
    }
}

