/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.util.Conv;
import java.io.IOException;

class S_PROCREF
extends DebugSymbol {
    private int module;
    private int checksum;
    private int paddingLen;

    S_PROCREF(short length, short type, BinaryReader reader, int ptr) throws IOException {
        this.processDebugSymbol(length, type);
        this.checksum = reader.readInt(ptr);
        this.offset = reader.readInt(ptr += 4);
        this.module = reader.readInt(ptr += 4);
        ptr += 4;
        if (this.checksum == 0) {
            byte nameLen = reader.readByte(ptr);
            this.name = reader.readAsciiString(++ptr, Conv.byteToInt((byte)nameLen));
            int val = (ptr += Conv.byteToInt((byte)nameLen)) & 0xF;
            switch (val) {
                case 1: 
                case 2: 
                case 3: {
                    this.paddingLen = 4 - val;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.paddingLen = 8 - val;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.paddingLen = 12 - val;
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    this.paddingLen = 16 - val;
                }
            }
            ptr += this.paddingLen;
        }
    }

    public int getModule() {
        return this.module;
    }

    public int getChecksum() {
        return this.checksum;
    }

    @Override
    public short getLength() {
        short len = super.getLength();
        if (this.checksum == 0) {
            len = (short)(len + (1 + this.name.length() + this.paddingLen));
        }
        return len;
    }
}

