/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.program.model.symbol.SymbolType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum DWARFTag {
    DW_TAG_array_type(1),
    DW_TAG_class_type(2),
    DW_TAG_entry_point(3),
    DW_TAG_enumeration_type(4),
    DW_TAG_formal_parameter(5),
    DW_TAG_imported_declaration(8),
    DW_TAG_label(10),
    DW_TAG_lexical_block(11),
    DW_TAG_member(13),
    DW_TAG_pointer_type(15),
    DW_TAG_reference_type(16),
    DW_TAG_compile_unit(17),
    DW_TAG_string_type(18),
    DW_TAG_structure_type(19),
    DW_TAG_subroutine_type(21),
    DW_TAG_typedef(22),
    DW_TAG_union_type(23),
    DW_TAG_unspecified_parameters(24),
    DW_TAG_variant(25),
    DW_TAG_common_block(26),
    DW_TAG_common_inclusion(27),
    DW_TAG_inheritance(28),
    DW_TAG_inlined_subroutine(29),
    DW_TAG_module(30),
    DW_TAG_ptr_to_member_type(31),
    DW_TAG_set_type(32),
    DW_TAG_subrange_type(33),
    DW_TAG_with_stmt(34),
    DW_TAG_access_declaration(35),
    DW_TAG_base_type(36),
    DW_TAG_catch_block(37),
    DW_TAG_const_type(38),
    DW_TAG_constant(39),
    DW_TAG_enumerator(40),
    DW_TAG_file_type(41),
    DW_TAG_friend(42),
    DW_TAG_namelist(43),
    DW_TAG_namelist_item(44),
    DW_TAG_packed_type(45),
    DW_TAG_subprogram(46),
    DW_TAG_template_type_param(47),
    DW_TAG_template_value_param(48),
    DW_TAG_thrown_type(49),
    DW_TAG_try_block(50),
    DW_TAG_variant_part(51),
    DW_TAG_variable(52),
    DW_TAG_volatile_type(53),
    DW_TAG_dwarf_procedure(54),
    DW_TAG_restrict_type(55),
    DW_TAG_interface_type(56),
    DW_TAG_namespace(57),
    DW_TAG_imported_module(58),
    DW_TAG_unspecified_type(59),
    DW_TAG_partial_unit(60),
    DW_TAG_imported_unit(61),
    DW_TAG_mutable_type(62),
    DW_TAG_condition(63),
    DW_TAG_shared_type(64),
    DW_TAG_type_unit(65),
    DW_TAG_rvalue_reference_type(66),
    DW_TAG_template_alias(67),
    DW_TAG_coarray_type(68),
    DW_TAG_generic_subrange(69),
    DW_TAG_dynamic_type(70),
    DW_TAG_atomic_type(71),
    DW_TAG_call_site(72),
    DW_TAG_call_site_parameter(73),
    DW_TAG_skeleton_unit(74),
    DW_TAG_immutable_type(75),
    DW_TAG_lo_user(16512),
    DW_TAG_MIPS_loop(16513),
    DW_TAG_HP_array_descriptor(16528),
    DW_TAG_HP_Bliss_field(16529),
    DW_TAG_HP_Bliss_field_set(16530),
    DW_TAG_format_label(16641),
    DW_TAG_function_template(16642),
    DW_TAG_class_template(16643),
    DW_TAG_GNU_BINCL(16644),
    DW_TAG_GNU_EINCL(16645),
    DW_TAG_GNU_template_template_param(16646),
    DW_TAG_GNU_template_parameter_pack(16647),
    DW_TAG_GNU_formal_parameter_pack(16648),
    DW_TAG_gnu_call_site(16649),
    DW_TAG_gnu_call_site_parameter(16650),
    DW_TAG_APPLE_ptrauth_type(17152),
    DW_TAG_hi_user(65535),
    DW_TAG_UNKNOWN(-1);

    private int id;
    private static Map<Integer, DWARFTag> lookupMap;
    private static final Set<DWARFTag> TYPE_TAGS;

    private DWARFTag(int id) {
        this.id = id;
    }

    public String name(int rawTagId) {
        return this != DW_TAG_UNKNOWN ? this.name() : "DW_TAG_??? %d (0x%x)".formatted(rawTagId, rawTagId);
    }

    public int getId() {
        return this.id;
    }

    public boolean isType() {
        return TYPE_TAGS.contains((Object)this);
    }

    public boolean isNamedType() {
        switch (this.ordinal()) {
            case 1: 
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 29: 
            case 39: 
            case 49: 
            case 50: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    public boolean isNameSpaceContainer() {
        switch (this.ordinal()) {
            case 1: 
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 39: 
            case 49: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    public boolean isStructureType() {
        switch (this.ordinal()) {
            case 1: 
            case 13: 
            case 16: 
            case 49: {
                return true;
            }
        }
        return false;
    }

    public boolean isFuncDefType() {
        switch (this.ordinal()) {
            case 14: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public String getContainerTypeName() {
        switch (this.ordinal()) {
            case 13: {
                return "struct";
            }
            case 1: {
                return "class";
            }
            case 3: {
                return "enum";
            }
            case 16: {
                return "union";
            }
            case 7: {
                return "lexical_block";
            }
            case 39: {
                return "subprogram";
            }
            case 14: {
                return "subr";
            }
            case 45: {
                return "var";
            }
        }
        return "unknown";
    }

    public SymbolType getSymbolType() {
        switch (this.ordinal()) {
            case 39: {
                return SymbolType.FUNCTION;
            }
            case 1: 
            case 3: 
            case 13: 
            case 16: 
            case 49: {
                return SymbolType.CLASS;
            }
            case 50: {
                return SymbolType.NAMESPACE;
            }
            case 4: {
                return SymbolType.PARAMETER;
            }
            case 45: {
                return SymbolType.LOCAL_VAR;
            }
        }
        return null;
    }

    public static DWARFTag of(int tagId) {
        return lookupMap.getOrDefault(tagId, DW_TAG_UNKNOWN);
    }

    private static Map<Integer, DWARFTag> buildLookup() {
        HashMap<Integer, DWARFTag> result = new HashMap<Integer, DWARFTag>();
        for (DWARFTag tag : DWARFTag.values()) {
            if (result.put(tag.id, tag) == null) continue;
            throw new RuntimeException("Duplicate DWARFTag enum const value " + String.valueOf((Object)tag));
        }
        return result;
    }

    static {
        lookupMap = DWARFTag.buildLookup();
        TYPE_TAGS = EnumSet.of(DW_TAG_base_type, new DWARFTag[]{DW_TAG_array_type, DW_TAG_typedef, DW_TAG_class_type, DW_TAG_interface_type, DW_TAG_structure_type, DW_TAG_union_type, DW_TAG_enumeration_type, DW_TAG_pointer_type, DW_TAG_reference_type, DW_TAG_rvalue_reference_type, DW_TAG_const_type, DW_TAG_volatile_type, DW_TAG_ptr_to_member_type, DW_TAG_unspecified_type, DW_TAG_subroutine_type});
    }
}

