/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.IBO64DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.SignedLeb128DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.UnsignedLeb128DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Data;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public interface StructConverter {
    public static final DataType BYTE = ByteDataType.dataType;
    public static final DataType WORD = WordDataType.dataType;
    public static final DataType DWORD = DWordDataType.dataType;
    public static final DataType QWORD = QWordDataType.dataType;
    public static final DataType ASCII = CharDataType.dataType;
    public static final DataType STRING = StringDataType.dataType;
    public static final DataType UTF8 = StringUTF8DataType.dataType;
    public static final DataType UTF16 = UnicodeDataType.dataType;
    public static final DataType POINTER = PointerDataType.dataType;
    public static final DataType VOID = VoidDataType.dataType;
    public static final DataType IBO32 = IBO32DataType.dataType;
    public static final DataType IBO64 = IBO64DataType.dataType;
    public static final UnsignedLeb128DataType ULEB128 = UnsignedLeb128DataType.dataType;
    public static final SignedLeb128DataType SLEB128 = SignedLeb128DataType.dataType;

    public DataType toDataType() throws DuplicateNameException, IOException;

    public static void setEndian(Data data, boolean bigEndian) throws Exception {
        for (int i = 0; i < data.getNumComponents(); ++i) {
            int j;
            Data component = data.getComponent(i);
            SettingsDefinition[] settings = component.getDataType().getSettingsDefinitions();
            for (j = 0; j < settings.length; ++j) {
                SettingsDefinition settingsDefinition = settings[j];
                if (!(settingsDefinition instanceof EndianSettingsDefinition)) continue;
                EndianSettingsDefinition endianSetting = (EndianSettingsDefinition)settingsDefinition;
                endianSetting.setBigEndian((Settings)component, bigEndian);
            }
            for (j = 0; j < component.getNumComponents(); ++j) {
                StructConverter.setEndian(component.getComponent(j), bigEndian);
            }
        }
    }
}

