/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import generic.theme.GIcon;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class NextPreviousFunctionAction
extends AbstractNextPreviousAction {
    private static final Icon ICON = new GIcon("icon.plugin.navigation.function");

    public NextPreviousFunctionAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Function", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ICON;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(70, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Function";
    }

    @Override
    protected String getInvertedNavigationTypeName() {
        return "Instruction Not In a Function";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getNextNonFunctionAddress(monitor, program, address);
        }
        Function nextFunction = this.getNextFunctionNotAtAddress(program, address, true);
        return nextFunction == null ? null : nextFunction.getEntryPoint();
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getPreviousNonFunctionAddress(monitor, program, address);
        }
        Function function = program.getListing().getFunctionContaining(address);
        if (this.isInsideFunctionNotAtEntry(function, address)) {
            return function.getEntryPoint();
        }
        Function nextFunction = this.getNextFunctionNotAtAddress(program, address, false);
        return nextFunction == null ? null : nextFunction.getEntryPoint();
    }

    private Address getNextNonFunctionAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        Function function = program.getListing().getFunctionContaining(address);
        if (function == null) {
            function = this.getNextFunction(program, address, true);
        }
        if (function == null) {
            return null;
        }
        return this.findNextInstructionAddressNotInFunction(monitor, program, function, true);
    }

    private Address findNextInstructionAddressNotInFunction(TaskMonitor monitor, Program program, Function startFunction, boolean isForward) throws CancelledException {
        Function function = startFunction;
        AddressSetView body = function.getBody();
        Address address = startFunction.getEntryPoint();
        InstructionIterator it = program.getListing().getInstructions(address, isForward);
        while (it.hasNext()) {
            monitor.checkCancelled();
            Instruction instruction = it.next();
            Address instructionAddress = instruction.getMinAddress();
            if (body.contains(instructionAddress)) continue;
            function = program.getListing().getFunctionContaining(instructionAddress);
            if (function == null) {
                return instructionAddress;
            }
            body = function.getBody();
        }
        return null;
    }

    private Address getPreviousNonFunctionAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        Function function = program.getListing().getFunctionContaining(address);
        if (function == null) {
            function = this.getNextFunction(program, address, false);
        }
        if (function == null) {
            return null;
        }
        return this.findNextInstructionAddressNotInFunction(monitor, program, function, false);
    }

    private boolean isInsideFunctionNotAtEntry(Function function, Address address) {
        if (function == null) {
            return false;
        }
        return !address.equals((Object)function.getEntryPoint());
    }

    private Function getNextFunction(Program program, Address address, boolean forward) {
        FunctionIterator functionIterator = program.getListing().getFunctions(address, forward);
        if (!functionIterator.hasNext()) {
            return null;
        }
        return (Function)functionIterator.next();
    }

    private Function getNextFunctionNotAtAddress(Program program, Address address, boolean forward) {
        FunctionIterator functionIterator = program.getListing().getFunctions(address, forward);
        if (!functionIterator.hasNext()) {
            return null;
        }
        Function nextFunction = (Function)functionIterator.next();
        if (!nextFunction.getEntryPoint().equals((Object)address)) {
            return nextFunction;
        }
        if (!functionIterator.hasNext()) {
            return null;
        }
        return (Function)functionIterator.next();
    }

    @Override
    protected void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        if (this.isInverted) {
            service.goTo(navigatable, address);
            return;
        }
        Program program = navigatable.getProgram();
        Function function = program.getListing().getFunctionAt(address);
        FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(program, address, null, 0, function.getPrototypeString(false, false));
        service.goTo(navigatable, (ProgramLocation)location, navigatable.getProgram());
    }
}

