/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.vertex;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import generic.theme.GColor;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class AbstractVisualVertexRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends BasicVertexRenderer<V, E> {
    private static final Color HIGHLIGHT_COLOR = new GColor("color.bg.highlight.visualgraph");
    private static final Color DROP_SHADOW_DARK = new GColor("color.bg.visualgraph.drop.shadow.dark");
    private static final Color DROP_SHADOW_LIGHT = new GColor("color.bg.visualgraph.drop.shadow.light");
    private Function<? super V, Paint> vertexFillPaintTransformer;

    public void setVertexFillPaintTransformer(Function<? super V, Paint> transformer) {
        this.vertexFillPaintTransformer = transformer;
    }

    public Function<? super V, Paint> getVertexFillPaintTransformer() {
        return this.vertexFillPaintTransformer;
    }

    protected GraphicsDecorator getEmphasisGraphics(GraphicsDecorator g, V vertex, RenderContext<V, E> rc, Layout<V, E> layout) {
        double emphasis;
        Graphics2D graphicsCopy = (Graphics2D)g.create();
        GraphicsDecorator decoratorCopy = new GraphicsDecorator(graphicsCopy);
        double alpha = vertex.getAlpha();
        if (alpha < 1.0) {
            decoratorCopy.setComposite((Composite)AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)alpha));
        }
        if ((emphasis = vertex.getEmphasis()) == 0.0) {
            return decoratorCopy;
        }
        AffineTransform transform = graphicsCopy.getTransform();
        double scaleX = transform.getScaleX();
        if ((int)scaleX == 1) {
            return decoratorCopy;
        }
        Point2D p = (Point2D)layout.apply(vertex);
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        p = multiLayerTransformer.transform(Layer.LAYOUT, p);
        double vertexX = p.getX();
        double vertexY = p.getY();
        AffineTransform xf = AffineTransform.getTranslateInstance(vertexX, vertexY);
        emphasis = this.adjustValueForCurrentScale(rc, emphasis, 0.5);
        double newScale = 1.0 + emphasis;
        xf.scale(newScale, newScale);
        xf.translate(-vertexX, -vertexY);
        transform.concatenate(xf);
        graphicsCopy.setTransform(transform);
        return decoratorCopy;
    }

    protected void paintHighlight(RenderContext<V, E> rc, V vertex, GraphicsDecorator g, Rectangle bounds) {
        if (!vertex.isSelected()) {
            return;
        }
        Paint oldPaint = g.getPaint();
        g.setPaint((Paint)HIGHLIGHT_COLOR);
        int offset = 10;
        offset = (int)this.adjustValueForCurrentScale(rc, offset, 0.9);
        g.fillOval(bounds.x - offset, bounds.y - offset, bounds.width + offset * 2, bounds.height + offset * 2);
        g.setPaint(oldPaint);
    }

    protected void paintDropShadow(RenderContext<V, E> rc, GraphicsDecorator g, Shape shape) {
        if (!this.isScaledPastVertexInteractionThreshold(rc)) {
            return;
        }
        int upperOffset = -3;
        int grayOffset = 15;
        int blackOffset = 5;
        g.setColor(DROP_SHADOW_LIGHT);
        AffineTransform xform3 = AffineTransform.getTranslateInstance(upperOffset, upperOffset);
        Shape xShape3 = xform3.createTransformedShape(shape);
        g.fill(xShape3);
        AffineTransform xform = AffineTransform.getTranslateInstance(grayOffset, grayOffset);
        Shape xShape = xform.createTransformedShape(shape);
        g.fill(xShape);
        g.setColor(DROP_SHADOW_DARK);
        AffineTransform xform2 = AffineTransform.getTranslateInstance(blackOffset, blackOffset);
        Shape xShape2 = xform2.createTransformedShape(shape);
        g.fill(xShape2);
    }

    protected boolean isScaledPastVertexInteractionThreshold(RenderContext<V, E> rc) {
        double scale = this.getScale(rc);
        return scale < 0.2;
    }

    protected Shape getCompactShape(RenderContext<V, E> rc, Layout<V, E> layout, V vertex) {
        Function vertexShaper = rc.getVertexShapeTransformer();
        Shape shape = null;
        if (vertexShaper instanceof VisualGraphVertexShapeTransformer) {
            VisualGraphVertexShapeTransformer vgShaper = (VisualGraphVertexShapeTransformer)vertexShaper;
            shape = vgShaper.transformToCompactShape(vertex);
        } else {
            shape = (Shape)vertexShaper.apply(vertex);
        }
        return this.transformFromLayoutToView(rc, layout, vertex, shape);
    }

    public Shape getFullShape(RenderContext<V, E> rc, Layout<V, E> layout, V vertex) {
        Function vertexShaper = rc.getVertexShapeTransformer();
        Shape shape = null;
        if (vertexShaper instanceof VisualGraphVertexShapeTransformer) {
            VisualGraphVertexShapeTransformer vgShaper = (VisualGraphVertexShapeTransformer)vertexShaper;
            shape = vgShaper.transformToFullShape(vertex);
        } else {
            shape = (Shape)vertexShaper.apply(vertex);
        }
        return this.transformFromLayoutToView(rc, layout, vertex, shape);
    }

    protected Shape transformFromLayoutToView(RenderContext<V, E> rc, Layout<V, E> layout, V vertex, Shape shape) {
        Point2D p = (Point2D)layout.apply(vertex);
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        p = multiLayerTransformer.transform(Layer.LAYOUT, p);
        float x = (float)p.getX();
        float y = (float)p.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        return xform.createTransformedShape(shape);
    }

    protected double adjustValueForCurrentScale(RenderContext<V, E> rc, double value, double ratioToScale) {
        double scale = this.getScale(rc);
        return value / Math.pow(scale, ratioToScale);
    }

    protected double getScale(RenderContext<V, E> rc) {
        MutableTransformer vt = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW);
        if (vt instanceof MutableTransformerDecorator) {
            vt = ((MutableTransformerDecorator)vt).getDelegate();
        }
        return vt.getScale();
    }
}

