/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSRatioValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class RatioValue
extends TypedValue
implements CSSRatioValue {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue antecedentValue;
    private PrimitiveValue consequentValue;

    public RatioValue() {
        super(CSSValue.Type.RATIO);
    }

    protected RatioValue(RatioValue ratioValue) {
        super(ratioValue);
        this.antecedentValue = ratioValue.antecedentValue.clone();
        this.consequentValue = ratioValue.consequentValue.clone();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(32);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.antecedentValue.writeCssText(simpleWriter);
        simpleWriter.write('/');
        this.consequentValue.writeCssText(simpleWriter);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory valueFactory = new ValueFactory();
        PrimitiveValue primitiveValue = valueFactory.parseMediaFeature(string);
        if (primitiveValue.getPrimitiveType() != CSSValue.Type.RATIO) {
            throw new DOMException(13, "Value is not a ratio.");
        }
        RatioValue ratioValue = (RatioValue)primitiveValue;
        this.antecedentValue = ratioValue.antecedentValue;
        this.consequentValue = ratioValue.consequentValue;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public PrimitiveValue getAntecedentValue() {
        return this.antecedentValue;
    }

    @Override
    public PrimitiveValue getConsequentValue() {
        return this.consequentValue;
    }

    public void setAntecedentValue(PrimitiveValue primitiveValue) throws DOMException {
        this.checkValueType(primitiveValue);
        this.antecedentValue = primitiveValue;
    }

    public void setConsequentValue(PrimitiveValue primitiveValue) throws DOMException {
        this.checkValueType(primitiveValue);
        this.consequentValue = primitiveValue;
    }

    private void checkValueType(PrimitiveValue primitiveValue) throws DOMException {
        if (primitiveValue == null) {
            throw new DOMException(5, "Null value in ratio.");
        }
        CSSValue.CssType cssType = primitiveValue.getCssValueType();
        CSSValue.Type type = primitiveValue.getPrimitiveType();
        if (cssType != CSSValue.CssType.PROXY && (cssType != CSSValue.CssType.TYPED || (type != CSSValue.Type.NUMERIC || RatioValue.isNotPositiveNumber(primitiveValue)) && type != CSSValue.Type.EXPRESSION)) {
            throw new DOMException(12, "Unexpected type in ratio: " + (Object)((Object)type));
        }
    }

    private static boolean isNotPositiveNumber(PrimitiveValue primitiveValue) {
        if (primitiveValue.getUnitType() != 0) {
            throw new DOMException(15, "Ratio components cannot have dimensions.");
        }
        if (!primitiveValue.isNegativeNumber()) {
            return false;
        }
        throw new DOMException(15, "Ratio components cannot be negative.");
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        switch (n) {
            case 0: {
                return this.antecedentValue;
            }
            case 1: {
                return this.consequentValue;
            }
        }
        return null;
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        if (styleValue == null) {
            throw new NullPointerException();
        }
        PrimitiveValue primitiveValue = (PrimitiveValue)styleValue;
        switch (n) {
            case 0: {
                this.antecedentValue = primitiveValue;
                break;
            }
            case 1: {
                this.consequentValue = primitiveValue;
            }
        }
    }

    @Override
    public int getComponentCount() {
        return 2;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(this.antecedentValue, this.consequentValue);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RatioValue ratioValue = (RatioValue)object;
        return Objects.equals(this.antecedentValue, ratioValue.antecedentValue) && Objects.equals(this.consequentValue, ratioValue.consequentValue);
    }

    @Override
    public RatioValue clone() {
        return new RatioValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            this.nextLexicalUnit = lexicalUnit;
        }
    }
}

