/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.WeakHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeMap;
import org.mozilla.javascript.NativeSet;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;

public class NativeWeakSet
extends IdScriptableObject {
    private static final long serialVersionUID = 2065753364224029534L;
    private static final Object MAP_TAG = "WeakSet";
    private boolean instanceOfWeakSet = false;
    private transient WeakHashMap<Scriptable, Boolean> map = new WeakHashMap();
    private static final int Id_constructor = 1;
    private static final int Id_add = 2;
    private static final int Id_delete = 3;
    private static final int Id_has = 4;
    private static final int SymbolId_toStringTag = 5;
    private static final int MAX_PROTOTYPE_ID = 5;

    static void init(Scriptable scriptable, boolean bl) {
        NativeWeakSet nativeWeakSet = new NativeWeakSet();
        nativeWeakSet.exportAsJSClass(5, scriptable, bl);
    }

    @Override
    public String getClassName() {
        return "WeakSet";
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(MAP_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 == null) {
                    NativeWeakSet nativeWeakSet = new NativeWeakSet();
                    nativeWeakSet.instanceOfWeakSet = true;
                    if (objectArray.length > 0) {
                        NativeSet.loadFromIterable(context, scriptable, nativeWeakSet, NativeMap.key(objectArray));
                    }
                    return nativeWeakSet;
                }
                throw ScriptRuntime.typeErrorById("msg.no.new", "WeakSet");
            }
            case 2: {
                return NativeWeakSet.realThis(scriptable2, idFunctionObject).js_add(NativeMap.key(objectArray));
            }
            case 3: {
                return NativeWeakSet.realThis(scriptable2, idFunctionObject).js_delete(NativeMap.key(objectArray));
            }
            case 4: {
                return NativeWeakSet.realThis(scriptable2, idFunctionObject).js_has(NativeMap.key(objectArray));
            }
        }
        throw new IllegalArgumentException("WeakMap.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    private Object js_add(Object object) {
        if (!ScriptRuntime.isObject(object)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(object));
        }
        this.map.put((Scriptable)object, Boolean.TRUE);
        return this;
    }

    private Object js_delete(Object object) {
        if (!ScriptRuntime.isObject(object)) {
            return Boolean.FALSE;
        }
        return this.map.remove(object) != null;
    }

    private Object js_has(Object object) {
        if (!ScriptRuntime.isObject(object)) {
            return Boolean.FALSE;
        }
        return this.map.containsKey(object);
    }

    private static NativeWeakSet realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        NativeWeakSet nativeWeakSet = NativeWeakSet.ensureType(scriptable, NativeWeakSet.class, idFunctionObject);
        if (!nativeWeakSet.instanceOfWeakSet) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", idFunctionObject.getFunctionName());
        }
        return nativeWeakSet;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 5) {
            this.initPrototypeValue(5, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
            return;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "add";
                break;
            }
            case 3: {
                n2 = 1;
                string = "delete";
                break;
            }
            case 4: {
                n2 = 1;
                string = "has";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(MAP_TAG, n, string, string2, n2);
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 5;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "add": {
                n = 2;
                break;
            }
            case "delete": {
                n = 3;
                break;
            }
            case "has": {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.map = new WeakHashMap();
    }
}

