/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EqualObjectGraphs;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;

public class ArrowFunction
extends BaseFunction {
    private static final long serialVersionUID = -7377989503697220633L;
    private final Callable targetFunction;
    private final Scriptable boundThis;

    public ArrowFunction(Context context, Scriptable scriptable, Callable callable, Scriptable scriptable2) {
        this.targetFunction = callable;
        this.boundThis = scriptable2;
        ScriptRuntime.setFunctionProtoAndParent(this, context, scriptable, false);
        BaseFunction baseFunction = ScriptRuntime.typeErrorThrower(context);
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.put("get", (Scriptable)nativeObject, (Object)baseFunction);
        nativeObject.put("set", (Scriptable)nativeObject, (Object)baseFunction);
        nativeObject.put("enumerable", (Scriptable)nativeObject, (Object)Boolean.FALSE);
        nativeObject.put("configurable", (Scriptable)nativeObject, (Object)Boolean.FALSE);
        nativeObject.preventExtensions();
        this.defineOwnProperty(context, "caller", nativeObject, false);
        this.defineOwnProperty(context, "arguments", nativeObject, false);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = this.boundThis != null ? this.boundThis : ScriptRuntime.getTopCallScope(context);
        return this.targetFunction.call(context, scriptable, scriptable3, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.typeErrorById("msg.not.ctor", this.decompile(0, 0));
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(scriptable);
        }
        throw ScriptRuntime.typeErrorById("msg.not.ctor", new Object[0]);
    }

    @Override
    public int getLength() {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).getLength();
        }
        return 0;
    }

    @Override
    public int getArity() {
        return this.getLength();
    }

    @Override
    String decompile(int n, int n2) {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).decompile(n, n2);
        }
        return super.decompile(n, n2);
    }

    static boolean equalObjectGraphs(ArrowFunction arrowFunction, ArrowFunction arrowFunction2, EqualObjectGraphs equalObjectGraphs) {
        return equalObjectGraphs.equalGraphs(arrowFunction.boundThis, arrowFunction2.boundThis) && equalObjectGraphs.equalGraphs(arrowFunction.targetFunction, arrowFunction2.targetFunction);
    }
}

