/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.Set;
import org.freeplane.features.link.ConnectorChecker;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;

class NodeConnectorChecker {
    NodeConnectorChecker() {
    }

    static boolean checkNodeConnectors(NodeModel node, ConnectorChecker connectorChecker) {
        NodeLinks nodeLinks = NodeLinks.getLinkExtension(node);
        if (nodeLinks != null) {
            for (NodeLinkModel nodeLinkModel : nodeLinks.getLinks()) {
                if (!(nodeLinkModel instanceof ConnectorModel) || !connectorChecker.check((ConnectorModel)nodeLinkModel)) continue;
                return true;
            }
        }
        if (!node.hasID()) {
            return false;
        }
        MapLinks mapLinks = MapLinks.getLinks(node.getMap());
        if (mapLinks == null) {
            return false;
        }
        Set<NodeLinkModel> set = mapLinks.get(node.getID());
        if (set == null) {
            return false;
        }
        for (NodeLinkModel l : set) {
            if (!(l instanceof ConnectorModel) || !connectorChecker.check((ConnectorModel)l)) continue;
            return true;
        }
        return false;
    }
}

