/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColUserMessageException;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;

public class FreeColModFile
extends FreeColDataFile
implements ObjectWithId {
    private static final Logger logger = Logger.getLogger(FreeColModFile.class.getName());
    private static final Map<String, FreeColModFile> allMods = new HashMap<String, FreeColModFile>();
    protected static final String SPECIFICATION_FILE = "specification.xml";
    private String id;
    private String parent;

    public FreeColModFile(File file) throws IOException {
        super(file);
        this.readModDescriptor();
    }

    public InputStream getSpecificationInputStream() throws IOException {
        try {
            return this.getInputStream(SPECIFICATION_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean hasSpecification() {
        boolean bl;
        block8: {
            InputStream is = this.getSpecificationInputStream();
            try {
                boolean bl2 = bl = is != null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public Specification getSpecification() throws IOException, XMLStreamException {
        Specification specification;
        block9: {
            InputStream si = this.getSpecificationInputStream();
            try {
                Specification specification2 = specification = si == null ? null : new Specification(si);
                if (si == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (si != null) {
                        try {
                            si.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FreeColUserMessageException e) {
                    throw e;
                }
                catch (RuntimeException rte) {
                    logger.log(Level.WARNING, "Parse error while reading specification " + this.getId(), rte);
                    throw new FreeColUserMessageException((StringTemplate)((StringTemplate)StringTemplate.template("error.mod").add("%id%", this.getId())).add("%name%", Messages.getName("mod." + this.getId())), (Throwable)rte);
                }
            }
            si.close();
        }
        return specification;
    }

    private InputStream getModDescriptorInputStream() throws IOException {
        return this.getInputStream("mod.xml");
    }

    protected final void readModDescriptor() throws IOException {
        try (FreeColXMLReader xr = new FreeColXMLReader(this.getModDescriptorInputStream());){
            xr.nextTag();
            this.id = xr.readId();
            this.parent = xr.getAttribute("parent", null);
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    public String getParent() {
        return this.parent;
    }

    public static List<FreeColModFile> getModsList() {
        ArrayList<FreeColModFile> ret = new ArrayList<FreeColModFile>();
        for (File f : FreeColDirectories.getModFileList()) {
            try {
                ret.add(new FreeColModFile(f));
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to load mod from: " + f, ioe);
            }
        }
        return ret;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static void loadMods() {
        if (allMods.isEmpty()) {
            for (FreeColModFile fcmf : FreeColModFile.getModsList()) {
                allMods.put(fcmf.getId(), fcmf);
            }
        }
    }

    public static FreeColModFile getFreeColModFile(String id) {
        return allMods.get(id);
    }
}

