define(["exports"],function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var currentId=0;function addUniquePlaylistItemId(item){item.PlaylistItemId||(item.PlaylistItemId="playlistItem"+currentId,currentId++)}function findPlaylistIndex(playlistItemId,list){for(var i=0,length=list.length;i<length;i++)if(list[i].PlaylistItemId===playlistItemId)return i;return-1}function PlayQueueManager(){this.reset()}function compareItemsDefault(a,b){a=a.PlayQueueOriginalIndex,b=b.PlayQueueOriginalIndex;return a===b?0:null!=a&&(null==b||a<b)?-1:1}PlayQueueManager.prototype.getPlaylistResult=function(options){options&&(startIndex=options.StartIndex,limit=options.Limit);var startIndex,limit,options=this._playlist,total=options.length,options=options.slice(startIndex||0);return limit&&options.length>limit&&(options.length=limit),{Items:options,TotalRecordCount:total}},PlayQueueManager.prototype.getPlaylist=function(){return this._playlist.slice(0)},PlayQueueManager.prototype.setPlaylist=function(items){for(var i=0,length=(items=items.slice(0)).length;i<length;i++)addUniquePlaylistItemId(items[i]);this._currentPlaylistItemId=null,this._currentPlaylistIndex=-1,this._playlist=items,this._repeatMode="RepeatNone",this._shuffle=!1},PlayQueueManager.prototype.queue=function(items){for(var i=0,length=items.length;i<length;i++)addUniquePlaylistItemId(items[i]),this._playlist.push(items[i])},PlayQueueManager.prototype.queueNext=function(items){for(var i=0,length=items.length;i<length;i++)addUniquePlaylistItemId(items[i]);var destArray,arrayToInsert,args,currentIndex=this.getCurrentPlaylistIndex();-1===currentIndex?currentIndex=this._playlist.length:currentIndex++,destArray=this._playlist,currentIndex=currentIndex,arrayToInsert=items,(args=[]).push(currentIndex),args.push(0),args=args.concat(arrayToInsert),destArray.splice.apply(destArray,args)},PlayQueueManager.prototype.getCurrentPlaylistLength=function(){return this._playlist.length},PlayQueueManager.prototype.getCurrentPlaylistIndex=function(){return this._currentPlaylistIndex},PlayQueueManager.prototype.getCurrentItem=function(){var index=this._currentPlaylistIndex;return-1===index?null:this._playlist[index]},PlayQueueManager.prototype.getCurrentPlaylistItemId=function(){return this._currentPlaylistItemId},PlayQueueManager.prototype.setPlaylistState=function(playlistItemId,playlistIndex){console.log("PlayQueueManager.setPlaylistState: playlistItemId: "+playlistItemId+", playlistIndex: "+playlistIndex),this._currentPlaylistItemId=playlistItemId,null==playlistIndex?this.refreshPlaylistIndex(playlistItemId):this._currentPlaylistIndex=playlistIndex},PlayQueueManager.prototype.refreshPlaylistIndex=function(playlistItemId){this._currentPlaylistIndex=findPlaylistIndex(playlistItemId||this._currentPlaylistItemId,this._playlist)},PlayQueueManager.prototype.setPlaylistIndex=function(playlistIndex){playlistIndex<0?this.setPlaylistState(null):this.setPlaylistState(this._playlist[playlistIndex].PlaylistItemId)},PlayQueueManager.prototype.removeFromPlaylist=function(playlistItemIds){var currentPlaylistItemId,playlist=this.getPlaylist();return playlist.length<=playlistItemIds.length?{result:"empty"}:(currentPlaylistItemId=this.getCurrentPlaylistItemId(),currentPlaylistItemId=-1!==playlistItemIds.indexOf(currentPlaylistItemId),this._playlist=playlist.filter(function(item){return!playlistItemIds.includes(item.PlaylistItemId)}),this.refreshPlaylistIndex(),{result:"removed",isCurrentIndex:currentPlaylistItemId})},PlayQueueManager.prototype.movePlaylistItem=function(playlistItemId,newIndex){for(var oldIndex,from,playlist=this.getPlaylist(),i=0,length=playlist.length;i<length;i++)if(playlist[i].PlaylistItemId===playlistItemId){oldIndex=i;break}if(-1===oldIndex||oldIndex===newIndex)return{result:"noop"};if(newIndex>=playlist.length)throw new Error("newIndex out of bounds");return from=oldIndex,playlist.splice(newIndex,0,playlist.splice(from,1)[0]),this._playlist=playlist,this.refreshPlaylistIndex(),{result:"moved",playlistItemId:playlistItemId,oldIndex:oldIndex,newIndex:newIndex}},PlayQueueManager.prototype.reset=function(){this._playlist=[],this._currentPlaylistItemId=null,this._currentPlaylistIndex=-1,this._repeatMode="RepeatNone",this._shuffle=!1},PlayQueueManager.prototype.setRepeatMode=function(value){this._repeatMode=value},PlayQueueManager.prototype.getRepeatMode=function(){return this._repeatMode},PlayQueueManager.prototype.setShuffle=function(value){if(this._shuffle!==value){this._shuffle=value;var currentPlaylistItemId=this.getCurrentPlaylistItemId(),items=this._playlist;if(value){!function(items){for(var startValue=0,i=0,length=items.length;i<length;i++)items[i].PlayQueueOriginalIndex=startValue,startValue++}(items);for(var array=items,currentIndex=array.length;0!==currentIndex;){var randomIndex=Math.floor(Math.random()*currentIndex),_ref=(currentIndex--,[array[randomIndex],array[currentIndex]]);array[currentIndex]=_ref[0],array[randomIndex]=_ref[1]}var firstItem,item,value=findPlaylistIndex(currentPlaylistItemId,items);0<value?(firstItem=items[value],item=items[0],items[0]=firstItem,items[value]=item,this._currentPlaylistIndex=0):this.refreshPlaylistIndex(currentPlaylistItemId)}else items.sort(compareItemsDefault),this.refreshPlaylistIndex(currentPlaylistItemId)}},PlayQueueManager.prototype.getShuffle=function(){return this._shuffle},PlayQueueManager.prototype.getNextItemInfo=function(){var newIndex,playlist=this.getPlaylist(),playlistLength=playlist.length;switch(this.getRepeatMode()){case"RepeatOne":newIndex=this.getCurrentPlaylistIndex();break;case"RepeatAll":playlistLength<=(newIndex=this.getCurrentPlaylistIndex()+1)&&(newIndex=0);break;default:newIndex=this.getCurrentPlaylistIndex()+1}return!(newIndex<0||playlistLength<=newIndex)&&(playlist=playlist[newIndex])?{item:playlist,index:newIndex}:null};_exports.default=PlayQueueManager});