/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class StandardManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(StandardManager.class);
    protected static final String name = "StandardManager";
    protected String pathname = "SESSIONS.ser";

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        String string2 = this.pathname;
        this.pathname = string;
        this.support.firePropertyChange("pathname", string2, this.pathname);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoad());
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Unreported exception in load() ", (Throwable)exception);
                }
            }
        } else {
            this.doLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doLoad() throws ClassNotFoundException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.loading", new Object[]{this.pathname}));
        }
        Loader loader = null;
        ClassLoader classLoader = null;
        Log log = null;
        try (FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Context context = this.getContext();
            loader = context.getLoader();
            log = context.getLogger();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Map map = this.sessions;
            synchronized (map) {
                block32: {
                    try {
                        try (CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream(bufferedInputStream, classLoader, log, this.getSessionAttributeValueClassNamePattern(), this.getWarnOnSessionAttributeFilterFailure());){
                            Integer n = (Integer)customObjectInputStream.readObject();
                            int n2 = n;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Loading " + n2 + " persisted sessions"));
                            }
                            for (int i = 0; i < n2; ++this.sessionCounter, ++i) {
                                StandardSession standardSession = this.getNewSession();
                                standardSession.readObjectData(customObjectInputStream);
                                standardSession.setManager(this);
                                this.sessions.put(standardSession.getIdInternal(), standardSession);
                                standardSession.activate();
                                if (standardSession.isValidInternal()) continue;
                                standardSession.setValid(true);
                                standardSession.expire();
                            }
                        }
                        if (!file.exists() || file.delete()) break block32;
                    }
                    catch (Throwable throwable) {
                        if (file.exists() && !file.delete()) {
                            this.log.warn((Object)sm.getString("standardManager.deletePersistedFileFail", new Object[]{file}));
                        }
                        throw throwable;
                    }
                    this.log.warn((Object)sm.getString("standardManager.deletePersistedFileFail", new Object[]{file}));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No persisted data file found");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Finish: Loading persisted sessions");
        }
    }

    @Override
    public void unload() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload());
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Unreported exception in unLoad()", (Throwable)exception);
                }
            }
        } else {
            this.doUnload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.unloading.debug"));
        }
        if (this.sessions.isEmpty()) {
            this.log.debug((Object)sm.getString("standardManager.unloading.nosessions"));
            return;
        }
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.unloading", new Object[]{this.pathname}));
        }
        ArrayList<StandardSession> arrayList = new ArrayList<StandardSession>();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
             BufferedOutputStream object = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(object);){
            Map map = this.sessions;
            synchronized (map) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unloading " + this.sessions.size() + " sessions"));
                }
                objectOutputStream.writeObject(this.sessions.size());
                for (Session session : this.sessions.values()) {
                    StandardSession standardSession = (StandardSession)session;
                    arrayList.add(standardSession);
                    standardSession.passivate();
                    standardSession.writeObjectData(objectOutputStream);
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Expiring " + arrayList.size() + " persisted sessions"));
        }
        for (StandardSession standardSession : arrayList) {
            try {
                standardSession.expire(false);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
            finally {
                standardSession.recycle();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unloading complete");
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            this.load();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log.error((Object)sm.getString("standardManager.managerLoad"), throwable);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        Session[] sessionArray;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.unload();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log.error((Object)sm.getString("standardManager.managerUnload"), throwable);
        }
        for (Session session : sessionArray = this.findSessions()) {
            try {
                if (!session.isValid()) continue;
                session.expire();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
            finally {
                session.recycle();
            }
        }
        super.stopInternal();
    }

    protected File file() {
        Context context;
        ServletContext servletContext;
        File file;
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file2 = new File(this.pathname);
        if (!file2.isAbsolute() && (file = (File)(servletContext = (context = this.getContext()).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file2 = new File(file, this.pathname);
        }
        return file2;
    }

    private class PrivilegedDoLoad
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoLoad() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doLoad();
            return null;
        }
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoUnload() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doUnload();
            return null;
        }
    }
}

