/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.EvaluationListener;
import jakarta.el.FunctionMapper;
import jakarta.el.ImportHandler;
import jakarta.el.LambdaExpression;
import jakarta.el.Util;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public abstract class ELContext {
    private Locale locale;
    private Map<Class<?>, Object> map;
    private boolean resolved = false;
    private ImportHandler importHandler = null;
    private List<EvaluationListener> listeners;
    private Deque<Map<String, Object>> lambdaArguments = new ArrayDeque<Map<String, Object>>();

    public void setPropertyResolved(boolean bl) {
        this.resolved = bl;
    }

    public void setPropertyResolved(Object object, Object object2) {
        this.setPropertyResolved(true);
        this.notifyPropertyResolved(object, object2);
    }

    public boolean isPropertyResolved() {
        return this.resolved;
    }

    public void putContext(Class<?> clazz, Object object) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(object);
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(clazz, object);
    }

    public Object getContext(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        if (this.map == null) {
            return null;
        }
        return this.map.get(clazz);
    }

    public abstract ELResolver getELResolver();

    public ImportHandler getImportHandler() {
        if (this.importHandler == null) {
            this.importHandler = new ImportHandler();
        }
        return this.importHandler;
    }

    public abstract FunctionMapper getFunctionMapper();

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public abstract VariableMapper getVariableMapper();

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EvaluationListener>();
        }
        this.listeners.add(evaluationListener);
    }

    public List<EvaluationListener> getEvaluationListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    public void notifyBeforeEvaluation(String string) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener evaluationListener : this.listeners) {
            try {
                evaluationListener.beforeEvaluation(this, string);
            }
            catch (Throwable throwable) {
                Util.handleThrowable(throwable);
            }
        }
    }

    public void notifyAfterEvaluation(String string) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener evaluationListener : this.listeners) {
            try {
                evaluationListener.afterEvaluation(this, string);
            }
            catch (Throwable throwable) {
                Util.handleThrowable(throwable);
            }
        }
    }

    public void notifyPropertyResolved(Object object, Object object2) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener evaluationListener : this.listeners) {
            try {
                evaluationListener.propertyResolved(this, object, object2);
            }
            catch (Throwable throwable) {
                Util.handleThrowable(throwable);
            }
        }
    }

    public boolean isLambdaArgument(String string) {
        for (Map<String, Object> map : this.lambdaArguments) {
            if (!map.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    public Object getLambdaArgument(String string) {
        for (Map<String, Object> map : this.lambdaArguments) {
            Object object = map.get(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void enterLambdaScope(Map<String, Object> map) {
        this.lambdaArguments.push(map);
    }

    public void exitLambdaScope() {
        this.lambdaArguments.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertToType(Object object, Class<T> clazz) {
        boolean bl = this.isPropertyResolved();
        this.setPropertyResolved(false);
        try {
            ELResolver eLResolver = this.getELResolver();
            if (eLResolver != null) {
                T t = eLResolver.convertToType(this, object, clazz);
                if (this.isPropertyResolved()) {
                    T t2 = t;
                    return t2;
                }
            }
        }
        finally {
            this.setPropertyResolved(bl);
        }
        if (object instanceof LambdaExpression && ELContext.isFunctionalInterface(clazz)) {
            ((LambdaExpression)object).setELContext(this);
        }
        return ELManager.getExpressionFactory().coerceToType(object, clazz);
    }

    static boolean isFunctionalInterface(Class<?> clazz) {
        Method[] methodArray;
        if (!clazz.isInterface()) {
            return false;
        }
        boolean bl = false;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) || ELContext.overridesObjectMethod(method)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean overridesObjectMethod(Method method) {
        return "equals".equals(method.getName()) ? method.getReturnType().equals(Boolean.TYPE) && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object.class) : ("hashCode".equals(method.getName()) ? method.getReturnType().equals(Integer.TYPE) && method.getParameterCount() == 0 : "toString".equals(method.getName()) && method.getReturnType().equals(String.class) && method.getParameterCount() == 0);
    }
}

