/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;

public class L2HMathJaxCommand
extends ControlSequence {
    protected TeXObject underlying;
    protected String mathJaxName;

    public L2HMathJaxCommand(ControlSequence controlSequence) {
        this(controlSequence, controlSequence.getName());
    }

    public L2HMathJaxCommand(TeXObject teXObject, String string) {
        this(teXObject, string, string);
    }

    public L2HMathJaxCommand(TeXObject teXObject, String string, String string2) {
        super(string);
        this.underlying = teXObject;
        this.mathJaxName = string2;
    }

    public TeXObject getUnderlying() {
        return this.underlying;
    }

    @Override
    public Object clone() {
        return new L2HMathJaxCommand(this.getUnderlying(), this.getName(), this.mathJaxName);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (teXParser.isMathMode() && l2HConverter.useMathJax()) {
            l2HConverter.write(String.format("\\%s ", this.mathJaxName));
        } else {
            this.underlying.process(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (teXParser.isMathMode() && l2HConverter.useMathJax()) {
            l2HConverter.write(String.format("\\%s ", this.mathJaxName));
        } else {
            this.underlying.process(teXParser);
        }
    }
}

