/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class LabelController
implements Controller {
    private final Home home;
    private final Float x;
    private final Float y;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView labelView;
    private String text;
    private TextStyle.Alignment alignment;
    private String fontName;
    private boolean fontNameSet;
    private Float fontSize;
    private Integer color;
    private Float pitch;
    private Boolean pitchEnabled;
    private Float elevation;

    public LabelController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.x = null;
        this.y = null;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public LabelController(Home home, float f, float f2, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.x = Float.valueOf(f);
        this.y = Float.valueOf(f2);
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.alignment = TextStyle.Alignment.CENTER;
        this.fontName = userPreferences.getDefaultFontName();
        this.fontNameSet = true;
        this.fontSize = Float.valueOf(userPreferences.getDefaultTextStyle(Label.class).getFontSize());
        this.pitchEnabled = Boolean.FALSE;
        this.elevation = Float.valueOf(0.0f);
    }

    protected void updateProperties() {
        List<Label> list = Home.getLabelsSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setText(null);
            this.setFontName(null);
            this.fontNameSet = false;
            this.setFontSize(null);
            this.setAlignment(null);
            this.setColor(null);
            this.setPitch(null);
            this.pitchEnabled = Boolean.FALSE;
            this.setElevation(null);
        } else {
            Serializable serializable;
            Serializable serializable2;
            Label label = list.get(0);
            String string = label.getText();
            if (string != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string.equals(list.get(i).getText())) continue;
                    string = null;
                    break;
                }
            }
            this.setText(string);
            TextStyle.Alignment alignment = label.getStyle() != null ? label.getStyle().getAlignment() : TextStyle.Alignment.CENTER;
            for (int i = 1; i < list.size(); ++i) {
                Label label2 = list.get(i);
                if (alignment.equals((Object)(label2.getStyle() != null ? label2.getStyle().getAlignment() : TextStyle.Alignment.CENTER))) continue;
                alignment = null;
                break;
            }
            this.setAlignment(alignment);
            String string2 = label.getStyle() != null ? label.getStyle().getFontName() : null;
            boolean bl = true;
            for (int i = 1; i < list.size(); ++i) {
                serializable2 = list.get(i);
                if (string2 == null && (((Label)serializable2).getStyle() == null || ((Label)serializable2).getStyle().getFontName() == null) || string2 != null && ((Label)serializable2).getStyle() != null && string2.equals(((Label)serializable2).getStyle().getFontName())) continue;
                bl = false;
                break;
            }
            this.setFontName(string2);
            this.fontNameSet = bl;
            float f = this.preferences.getDefaultTextStyle(Label.class).getFontSize();
            serializable2 = Float.valueOf(label.getStyle() != null ? label.getStyle().getFontSize() : f);
            for (int i = 1; i < list.size(); ++i) {
                serializable = list.get(i);
                if (((Float)serializable2).equals(Float.valueOf(((Label)serializable).getStyle() != null ? ((Label)serializable).getStyle().getFontSize() : f))) continue;
                serializable2 = null;
                break;
            }
            this.setFontSize((Float)serializable2);
            Integer n = label.getColor();
            if (n != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n.equals(list.get(i).getColor())) continue;
                    n = null;
                    break;
                }
            }
            this.setColor(n);
            serializable = label.getPitch();
            for (int i = 1; i < list.size(); ++i) {
                Label label3 = list.get(i);
                if (serializable == null && label3.getPitch() == null || serializable != null && ((Float)serializable).equals(label3.getPitch())) continue;
                serializable = null;
                break;
            }
            this.setPitch((Float)serializable);
            Boolean bl2 = label.getPitch() != null;
            for (int i = 1; i < list.size(); ++i) {
                if (bl2.equals(list.get(i).getPitch() != null)) continue;
                bl2 = null;
                break;
            }
            this.pitchEnabled = bl2;
            Float f2 = Float.valueOf(label.getElevation());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.floatValue() == list.get(i).getElevation()) continue;
                f2 = null;
                break;
            }
            this.setElevation(f2);
        }
    }

    @Override
    public DialogView getView() {
        if (this.labelView == null) {
            this.labelView = this.viewFactory.createLabelView(this.x == null, this.preferences, this);
        }
        return this.labelView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void setText(String string) {
        if (string != this.text) {
            String string2 = this.text;
            this.text = string;
            this.propertyChangeSupport.firePropertyChange(Property.TEXT.name(), string2, string);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setAlignment(TextStyle.Alignment alignment) {
        if (alignment != this.alignment) {
            TextStyle.Alignment alignment2 = this.alignment;
            this.alignment = alignment;
            this.propertyChangeSupport.firePropertyChange(Property.ALIGNMENT.name(), (Object)alignment2, (Object)alignment);
        }
    }

    public TextStyle.Alignment getAlignment() {
        return this.alignment;
    }

    public void setFontName(String string) {
        if (string != this.fontName) {
            String string2 = this.fontName;
            this.fontName = string;
            this.propertyChangeSupport.firePropertyChange(Property.FONT_NAME.name(), string2, string);
            this.fontNameSet = true;
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontSize(Float f) {
        if (f != this.fontSize) {
            Float f2 = this.fontSize;
            this.fontSize = f;
            this.propertyChangeSupport.firePropertyChange(Property.FONT_SIZE.name(), f2, f);
        }
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public boolean isFontNameSet() {
        return this.fontNameSet;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setPitch(Float f) {
        if (f != this.pitch) {
            Float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), f2, f);
        }
        this.pitchEnabled = f != null;
    }

    public Float getPitch() {
        return this.pitch;
    }

    public Boolean isPitchEnabled() {
        return this.pitchEnabled;
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    protected Label createLabel(String string, float f, float f2) {
        Label label = new Label(string, f, f2);
        this.home.addLabel(label);
        return label;
    }

    public void createLabel() {
        String string = this.getText();
        if (string != null && string.trim().length() > 0) {
            List<Selectable> list = this.home.getSelectedItems();
            boolean bl = this.home.isBasePlanLocked();
            boolean bl2 = this.home.isAllLevelsSelection();
            Label label = this.createLabel(string, this.x.floatValue(), this.y.floatValue());
            TextStyle.Alignment alignment = this.getAlignment();
            String string2 = this.getFontName();
            Float f = this.getFontSize();
            if (string2 != null || f != null || this.getPitch() != null) {
                TextStyle textStyle = this.preferences.getDefaultTextStyle(Label.class);
                if (string2 != null) {
                    textStyle = textStyle.deriveStyle(string2);
                }
                if (f != null) {
                    textStyle = textStyle.deriveStyle(f.floatValue());
                }
                if (alignment != null) {
                    textStyle = textStyle.deriveStyle(alignment);
                }
                label.setStyle(textStyle);
            }
            if (this.color != null) {
                label.setColor(this.color);
            }
            label.setColor(this.getColor());
            label.setPitch(this.getPitch());
            label.setElevation(this.getElevation().floatValue());
            boolean bl3 = bl && !this.isLabelPartOfBasePlan(label);
            LabelController.doAddAndSelectLabel(this.home, label, false, bl3);
            if (this.undoSupport != null) {
                LabelCreationUndoableEdit labelCreationUndoableEdit = new LabelCreationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), bl, bl2, label, bl3);
                this.undoSupport.postEdit(labelCreationUndoableEdit);
            }
            if (string.indexOf(10) < 0) {
                this.preferences.addAutoCompletionString("LabelText", string);
            }
        }
    }

    private static void doAddAndSelectLabel(Home home, Label label, boolean bl, boolean bl2) {
        if (bl) {
            home.addLabel(label);
        }
        home.setBasePlanLocked(bl2);
        home.setSelectedItems(Arrays.asList(label));
        home.setAllLevelsSelection(false);
    }

    private static void doDeleteLabel(Home home, Label label, boolean bl) {
        home.deleteLabel(label);
        home.setBasePlanLocked(bl);
    }

    protected boolean isLabelPartOfBasePlan(Label label) {
        return true;
    }

    public void modifyLabels() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Label> list2 = Home.getLabelsSubList(list);
        if (!list2.isEmpty()) {
            String string = this.getText();
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            TextStyle.Alignment alignment = this.getAlignment();
            String string2 = this.getFontName();
            boolean bl = this.isFontNameSet();
            Float f = this.getFontSize();
            Integer n = this.getColor();
            Float f2 = this.getPitch();
            Boolean bl2 = this.isPitchEnabled();
            Float f3 = this.getElevation();
            ModifiedLabel[] modifiedLabelArray = new ModifiedLabel[list2.size()];
            for (int i = 0; i < modifiedLabelArray.length; ++i) {
                modifiedLabelArray[i] = new ModifiedLabel(list2.get(i));
            }
            TextStyle textStyle = this.preferences.getDefaultTextStyle(Label.class);
            LabelController.doModifyLabels(modifiedLabelArray, string, alignment, string2, bl, f, textStyle, n, f2, bl2, f3);
            if (this.undoSupport != null) {
                LabelModificationUndoableEdit labelModificationUndoableEdit = new LabelModificationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), modifiedLabelArray, string, alignment, string2, bl, f, textStyle, n, f2, bl2, f3);
                this.undoSupport.postEdit(labelModificationUndoableEdit);
            }
            if (string != null && string.indexOf(10) < 0) {
                this.preferences.addAutoCompletionString("LabelText", string);
            }
        }
    }

    private static void doModifyLabels(ModifiedLabel[] modifiedLabelArray, String string, TextStyle.Alignment alignment, String string2, boolean bl, Float f, TextStyle textStyle, Integer n, Float f2, Boolean bl2, Float f3) {
        for (ModifiedLabel modifiedLabel : modifiedLabelArray) {
            Label label = modifiedLabel.getLabel();
            if (string != null) {
                label.setText(string);
            }
            if (alignment != null) {
                label.setStyle(label.getStyle() != null ? label.getStyle().deriveStyle(alignment) : textStyle.deriveStyle(alignment));
            }
            if (bl) {
                label.setStyle(label.getStyle() != null ? label.getStyle().deriveStyle(string2) : textStyle.deriveStyle(string2));
            }
            if (f != null) {
                label.setStyle(label.getStyle() != null ? label.getStyle().deriveStyle(f.floatValue()) : textStyle.deriveStyle(f.floatValue()));
            }
            if (n != null) {
                label.setColor(n);
            }
            if (bl2 != null) {
                if (Boolean.FALSE.equals(bl2)) {
                    label.setPitch(null);
                } else if (f2 != null) {
                    label.setPitch(f2);
                    if (label.getStyle() == null) {
                        label.setStyle(textStyle);
                    }
                }
            }
            if (f3 == null) continue;
            label.setElevation(f3.floatValue());
        }
    }

    private static void undoModifyLabels(ModifiedLabel[] modifiedLabelArray) {
        for (ModifiedLabel modifiedLabel : modifiedLabelArray) {
            modifiedLabel.reset();
        }
    }

    private static final class ModifiedLabel {
        private final Label label;
        private final String text;
        private final TextStyle style;
        private final Integer color;
        private final Float pitch;
        private final float elevation;

        public ModifiedLabel(Label label) {
            this.label = label;
            this.text = label.getText();
            this.style = label.getStyle();
            this.color = label.getColor();
            this.pitch = label.getPitch();
            this.elevation = label.getElevation();
        }

        public Label getLabel() {
            return this.label;
        }

        public void reset() {
            this.label.setText(this.text);
            this.label.setStyle(this.style);
            this.label.setColor(this.color);
            this.label.setPitch(this.pitch);
            this.label.setElevation(this.elevation);
        }
    }

    public static enum Property {
        TEXT,
        ALIGNMENT,
        FONT_NAME,
        FONT_SIZE,
        COLOR,
        PITCH,
        ELEVATION;

    }

    private static class LabelCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final Label label;
        private final boolean newBasePlanLocked;

        private LabelCreationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, Label label, boolean bl3) {
            super(userPreferences, LabelController.class, "undoCreateLabelName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.label = label;
            this.newBasePlanLocked = bl3;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            LabelController.doDeleteLabel(this.home, this.label, this.oldBasePlanLocked);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
            this.home.setAllLevelsSelection(this.oldAllLevelsSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            LabelController.doAddAndSelectLabel(this.home, this.label, true, this.newBasePlanLocked);
        }
    }

    private static class LabelModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final ModifiedLabel[] modifiedLabels;
        private final String text;
        private final TextStyle.Alignment alignment;
        private final String fontName;
        private final boolean fontNameSet;
        private final Float fontSize;
        private final TextStyle defaultStyle;
        private final Integer color;
        private final Float pitch;
        private final Boolean pitchEnabled;
        private final Float elevation;

        private LabelModificationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, ModifiedLabel[] modifiedLabelArray, String string, TextStyle.Alignment alignment, String string2, boolean bl, Float f, TextStyle textStyle, Integer n, Float f2, Boolean bl2, Float f3) {
            super(userPreferences, LabelController.class, "undoModifyLabelsName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.modifiedLabels = modifiedLabelArray;
            this.text = string;
            this.alignment = alignment;
            this.fontName = string2;
            this.fontNameSet = bl;
            this.fontSize = f;
            this.defaultStyle = textStyle;
            this.color = n;
            this.pitch = f2;
            this.pitchEnabled = bl2;
            this.elevation = f3;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            LabelController.undoModifyLabels(this.modifiedLabels);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            LabelController.doModifyLabels(this.modifiedLabels, this.text, this.alignment, this.fontName, this.fontNameSet, this.fontSize, this.defaultStyle, this.color, this.pitch, this.pitchEnabled, this.elevation);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }
    }
}

