# This file has been autogenerated by the pywayland scanner

# Copyright © 2021 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_security_context_v1 import WpSecurityContextV1


class WpSecurityContextManagerV1(Interface):
    """Client security context manager

    This interface allows a client to register a new Wayland connection to the
    compositor and attach a security context to it.

    This is intended to be used by sandboxes. Sandbox engines attach a security
    context to all connections coming from inside the sandbox. The compositor
    can then restrict the features that the sandboxed connections can use.

    Compositors should forbid nesting multiple security contexts by not
    exposing :class:`WpSecurityContextManagerV1` global to clients with a
    security context attached, or by sending the nested protocol error. Nested
    security contexts are dangerous because they can potentially allow
    privilege escalation of a sandboxed client.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_security_context_manager_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_listen_fd = 1
        nested = 2


class WpSecurityContextManagerV1Proxy(Proxy[WpSecurityContextManagerV1]):
    interface = WpSecurityContextManagerV1

    @WpSecurityContextManagerV1.request()
    def destroy(self) -> None:
        """Destroy the manager object

        Destroy the manager. This doesn't destroy objects created with the
        manager.
        """
        self._marshal(0)
        self._destroy()

    @WpSecurityContextManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpSecurityContextV1),
        Argument(ArgumentType.FileDescriptor),
        Argument(ArgumentType.FileDescriptor),
    )
    def create_listener(self, listen_fd: int, close_fd: int) -> Proxy[WpSecurityContextV1]:
        """Create a new security context

        Creates a new security context with a socket listening FD.

        The compositor will accept new client connections on listen_fd.
        listen_fd must be ready to accept new connections when this request is
        sent by the client. In other words, the client must call bind(2) and
        listen(2) before sending the FD.

        close_fd is a FD closed by the client when the compositor should stop
        accepting new connections on listen_fd.

        The compositor must continue to accept connections on listen_fd when
        the Wayland client which created the security context disconnects.

        :param listen_fd:
            listening socket FD
        :type listen_fd:
            `ArgumentType.FileDescriptor`
        :param close_fd:
            FD closed when done
        :type close_fd:
            `ArgumentType.FileDescriptor`
        :returns:
            :class:`~pywayland.protocol.security_context_v1.WpSecurityContextV1`
        """
        id = self._marshal_constructor(1, WpSecurityContextV1, listen_fd, close_fd)
        return id


class WpSecurityContextManagerV1Resource(Resource):
    interface = WpSecurityContextManagerV1


class WpSecurityContextManagerV1Global(Global):
    interface = WpSecurityContextManagerV1


WpSecurityContextManagerV1._gen_c()
WpSecurityContextManagerV1.proxy_class = WpSecurityContextManagerV1Proxy
WpSecurityContextManagerV1.resource_class = WpSecurityContextManagerV1Resource
WpSecurityContextManagerV1.global_class = WpSecurityContextManagerV1Global
