/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.collector;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.planner.physical.collector.Collector;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;
import shaded.com.google.common.collect.ImmutableList;

public class BucketCollector
implements Collector {
    private final NamedExpression bucketExpr;
    private final Supplier<Collector> supplier;
    private final Map<ExprValue, Collector> collectorMap = new TreeMap<ExprValue, Collector>();
    private int bucketIndex = 0;

    @Override
    public void collect(BindingTuple input) {
        ExprValue bucketKey = this.bucketKey(input);
        this.collectorMap.putIfAbsent(bucketKey, this.supplier.get());
        this.collectorMap.get(bucketKey).collect(input);
    }

    protected ExprValue bucketKey(BindingTuple tuple) {
        return this.bucketExpr.valueOf(tuple);
    }

    @Override
    public List<ExprValue> results() {
        ExprValue[] buckets = this.allocateBuckets();
        for (Map.Entry<ExprValue, Collector> entry : this.collectorMap.entrySet()) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (ExprValue tuple : entry.getValue().results()) {
                LinkedHashMap<String, ExprValue> tmp = new LinkedHashMap<String, ExprValue>();
                tmp.put(this.bucketExpr.getNameOrAlias(), entry.getKey());
                tmp.putAll(tuple.tupleValue());
                builder.add(ExprTupleValue.fromExprValueMap(tmp));
            }
            buckets[this.locateBucket((ExprValue)entry.getKey())] = new ExprCollectionValue((List<ExprValue>)((Object)builder.build()));
        }
        return Arrays.stream(buckets).filter(Objects::nonNull).flatMap(v -> v.collectionValue().stream()).collect(Collectors.toList());
    }

    protected ExprValue[] allocateBuckets() {
        return new ExprValue[this.collectorMap.size()];
    }

    protected int locateBucket(ExprValue value) {
        return this.bucketIndex++;
    }

    @Generated
    public BucketCollector(NamedExpression bucketExpr, Supplier<Collector> supplier) {
        this.bucketExpr = bucketExpr;
        this.supplier = supplier;
    }
}

