/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.system;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;

public class OpenSearchSystemIndexEnumerator
implements Enumerator<Object> {
    private final List<String> fields;
    private final OpenSearchSystemRequest request;
    private Iterator<ExprValue> iterator;
    private ExprValue current;

    public OpenSearchSystemIndexEnumerator(List<String> fields2, OpenSearchSystemRequest request) {
        this.fields = fields2;
        this.request = request;
        this.current = null;
        this.iterator = request.search().iterator();
    }

    @Override
    public Object current() {
        return this.fields.stream().map(k -> this.current.tupleValue().getOrDefault(k, ExprNullValue.of()).valueForCalcite()).toArray();
    }

    @Override
    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.iterator = this.request.search().iterator();
        this.current = null;
    }

    @Override
    public void close() {
        this.iterator = null;
        this.current = null;
    }
}

