/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.units;

import java.text.ParseException;
import org.locationtech.proj4j.units.AngleFormat;
import org.locationtech.proj4j.units.Unit;

public class DegreeUnit
extends Unit {
    static final long serialVersionUID = -3212757578604686538L;
    private static AngleFormat format = new AngleFormat("DdM", true);

    public DegreeUnit() {
        super("degree", "degrees", "deg", 1.0);
    }

    @Override
    public double parse(String s2) throws NumberFormatException {
        try {
            return format.parse(s2).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    @Override
    public String format(double n) {
        return format.format(n) + " " + this.abbreviation;
    }

    @Override
    public String format(double n, boolean abbrev) {
        if (abbrev) {
            return format.format(n) + " " + this.abbreviation;
        }
        return format.format(n);
    }

    @Override
    public String format(double x, double y, boolean abbrev) {
        if (abbrev) {
            return format.format(x) + "/" + format.format(y) + " " + this.abbreviation;
        }
        return format.format(x) + "/" + format.format(y);
    }
}

