/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kmssdkv2;

import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;

class RequestClientCacher
implements ExecutionInterceptor {
    private final ConcurrentHashMap<Region, KmsClient> cache_;
    private final Region region_;
    private KmsClient client_;
    volatile boolean ranBefore_ = false;

    RequestClientCacher(ConcurrentHashMap<Region, KmsClient> cache, Region region) {
        this.region_ = region;
        this.cache_ = cache;
    }

    public KmsClient setClient(KmsClient client) {
        this.client_ = client;
        return client;
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        if (this.ranBefore_) {
            return;
        }
        this.ranBefore_ = true;
        this.cache_.putIfAbsent(this.region_, this.client_);
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        if (this.ranBefore_) {
            return;
        }
        if (!(context.exception() instanceof AwsServiceException)) {
            return;
        }
        this.ranBefore_ = true;
        this.cache_.putIfAbsent(this.region_, this.client_);
    }
}

