/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.sgd;

import java.util.SplittableRandom;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.common.sgd.AbstractLinearSGDModel;
import org.tribuo.common.sgd.AbstractSGDTrainer;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.StochasticGradientOptimiser;

public abstract class AbstractLinearSGDTrainer<T extends Output<T>, U, V extends AbstractLinearSGDModel<T>>
extends AbstractSGDTrainer<T, U, V, LinearParameters> {
    private static final Logger logger = Logger.getLogger(AbstractLinearSGDTrainer.class.getName());

    protected AbstractLinearSGDTrainer(StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, int minibatchSize, long seed) {
        super(optimiser, epochs, loggingInterval, minibatchSize, seed, true);
        this.postConfig();
    }

    protected AbstractLinearSGDTrainer() {
        super(true);
    }

    @Override
    protected String getName() {
        return "linear-sgd-model";
    }

    @Override
    protected LinearParameters createParameters(int numFeatures, int numOutputs, SplittableRandom localRNG) {
        return new LinearParameters(numFeatures + 1, numOutputs);
    }
}

