/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.exception.ParseException;
import java.io.DataOutput;
import java.io.IOException;

public class PrimitivesParser {
    private static long getLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off] << 56);
    }

    private static int getInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off] & 0xFF) << 24);
    }

    private static short getShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + ((b[off] & 0xFF) << 8));
    }

    public static long parseLong(byte[] b, int off) throws ParseException {
        int size = 8;
        int len = b.length - off;
        if (len >= 8) {
            return PrimitivesParser.getLong(b, off);
        }
        throw new ParseException("Not enough bytes to parse a long.");
    }

    public static int parseInt(byte[] b, int off) throws ParseException {
        int size = 4;
        int len = b.length - off;
        if (len >= 4) {
            return PrimitivesParser.getInt(b, off);
        }
        throw new ParseException("Not enough bytes to parse an integer.");
    }

    public static short parseShort(byte[] b, int off) {
        int size = 2;
        int len = b.length - off;
        if (len >= 2) {
            return PrimitivesParser.getShort(b, off);
        }
        throw new ParseException("Not enough bytes to parse a short.");
    }

    public static int parseUnsignedShort(byte[] b, int off) {
        short signedResult = PrimitivesParser.parseShort(b, off);
        if (signedResult >= 0) {
            return signedResult;
        }
        return 65536 + signedResult;
    }

    public static void writeUnsignedShort(DataOutput out, int uShort) throws IOException {
        if (uShort < 0 || uShort > 65535) {
            throw new IllegalArgumentException("Unsigned shorts must be between 0 and 65535");
        }
        if (uShort < Short.MAX_VALUE) {
            out.writeShort(uShort);
        } else {
            out.writeShort(uShort - 65535 - 1);
        }
    }

    public static byte parseByte(byte[] b, int off) {
        boolean size = true;
        int len = b.length - off;
        if (len >= 1) {
            return b[off];
        }
        throw new ParseException("Not enough bytes to parse a byte.");
    }
}

