/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamResourceDiscoveryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamResourceDiscoveryRequest> {
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::ipamResourceDiscoveryId)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("IpamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::description)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<AddIpamOperatingRegion>> ADD_OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddOperatingRegions").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::addOperatingRegions)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::addOperatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOperatingRegion").unmarshallLocationName("AddOperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemoveIpamOperatingRegion>> REMOVE_OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveOperatingRegions").getter(ModifyIpamResourceDiscoveryRequest.getter(ModifyIpamResourceDiscoveryRequest::removeOperatingRegions)).setter(ModifyIpamResourceDiscoveryRequest.setter(Builder::removeOperatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOperatingRegion").unmarshallLocationName("RemoveOperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoveIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERY_ID_FIELD, DESCRIPTION_FIELD, ADD_OPERATING_REGIONS_FIELD, REMOVE_OPERATING_REGIONS_FIELD));
    private final String ipamResourceDiscoveryId;
    private final String description;
    private final List<AddIpamOperatingRegion> addOperatingRegions;
    private final List<RemoveIpamOperatingRegion> removeOperatingRegions;

    private ModifyIpamResourceDiscoveryRequest(BuilderImpl builder) {
        super(builder);
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.description = builder.description;
        this.addOperatingRegions = builder.addOperatingRegions;
        this.removeOperatingRegions = builder.removeOperatingRegions;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAddOperatingRegions() {
        return this.addOperatingRegions != null && !(this.addOperatingRegions instanceof SdkAutoConstructList);
    }

    public final List<AddIpamOperatingRegion> addOperatingRegions() {
        return this.addOperatingRegions;
    }

    public final boolean hasRemoveOperatingRegions() {
        return this.removeOperatingRegions != null && !(this.removeOperatingRegions instanceof SdkAutoConstructList);
    }

    public final List<RemoveIpamOperatingRegion> removeOperatingRegions() {
        return this.removeOperatingRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOperatingRegions() ? this.addOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveOperatingRegions() ? this.removeOperatingRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceDiscoveryRequest)) {
            return false;
        }
        ModifyIpamResourceDiscoveryRequest other = (ModifyIpamResourceDiscoveryRequest)((Object)obj);
        return Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.description(), other.description()) && this.hasAddOperatingRegions() == other.hasAddOperatingRegions() && Objects.equals(this.addOperatingRegions(), other.addOperatingRegions()) && this.hasRemoveOperatingRegions() == other.hasRemoveOperatingRegions() && Objects.equals(this.removeOperatingRegions(), other.removeOperatingRegions());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamResourceDiscoveryRequest").add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("Description", (Object)this.description()).add("AddOperatingRegions", this.hasAddOperatingRegions() ? this.addOperatingRegions() : null).add("RemoveOperatingRegions", this.hasRemoveOperatingRegions() ? this.removeOperatingRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddOperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.addOperatingRegions()));
            }
            case "RemoveOperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.removeOperatingRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceDiscoveryRequest, T> g) {
        return obj -> g.apply((ModifyIpamResourceDiscoveryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String ipamResourceDiscoveryId;
        private String description;
        private List<AddIpamOperatingRegion> addOperatingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<RemoveIpamOperatingRegion> removeOperatingRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceDiscoveryRequest model) {
            super(model);
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.description(model.description);
            this.addOperatingRegions(model.addOperatingRegions);
            this.removeOperatingRegions(model.removeOperatingRegions);
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getAddOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.addOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(addOperatingRegions);
        }

        @Override
        public final Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copy(addOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(AddIpamOperatingRegion ... addOperatingRegions) {
            this.addOperatingRegions(Arrays.asList(addOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... addOperatingRegions) {
            this.addOperatingRegions(Stream.of(addOperatingRegions).map(c -> (AddIpamOperatingRegion)((AddIpamOperatingRegion.Builder)AddIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOperatingRegion.Builder> getRemoveOperatingRegions() {
            List<RemoveIpamOperatingRegion.Builder> result = RemoveIpamOperatingRegionSetCopier.copyToBuilder(this.removeOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion.BuilderImpl> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copyFromBuilder(removeOperatingRegions);
        }

        @Override
        public final Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copy(removeOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(RemoveIpamOperatingRegion ... removeOperatingRegions) {
            this.removeOperatingRegions(Arrays.asList(removeOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder> ... removeOperatingRegions) {
            this.removeOperatingRegions(Stream.of(removeOperatingRegions).map(c -> (RemoveIpamOperatingRegion)((RemoveIpamOperatingRegion.Builder)RemoveIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamResourceDiscoveryRequest build() {
            return new ModifyIpamResourceDiscoveryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamResourceDiscoveryRequest> {
        public Builder ipamResourceDiscoveryId(String var1);

        public Builder description(String var1);

        public Builder addOperatingRegions(Collection<AddIpamOperatingRegion> var1);

        public Builder addOperatingRegions(AddIpamOperatingRegion ... var1);

        public Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... var1);

        public Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> var1);

        public Builder removeOperatingRegions(RemoveIpamOperatingRegion ... var1);

        public Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

