/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamResourceDiscoveryAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamResourceDiscoveryAssociation> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ownerId)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryAssociationId").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ipamResourceDiscoveryAssociationId)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ipamResourceDiscoveryAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryAssociationId").unmarshallLocationName("ipamResourceDiscoveryAssociationId").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryAssociationArn").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ipamResourceDiscoveryAssociationArn)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ipamResourceDiscoveryAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryAssociationArn").unmarshallLocationName("ipamResourceDiscoveryAssociationArn").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ipamResourceDiscoveryId)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("ipamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ipamId)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("ipamId").build()}).build();
    private static final SdkField<String> IPAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamArn").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ipamArn)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ipamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn").unmarshallLocationName("ipamArn").build()}).build();
    private static final SdkField<String> IPAM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamRegion").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::ipamRegion)).setter(IpamResourceDiscoveryAssociation.setter(Builder::ipamRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion").unmarshallLocationName("ipamRegion").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::isDefault)).setter(IpamResourceDiscoveryAssociation.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").unmarshallLocationName("isDefault").build()}).build();
    private static final SdkField<String> RESOURCE_DISCOVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceDiscoveryStatus").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::resourceDiscoveryStatusAsString)).setter(IpamResourceDiscoveryAssociation.setter(Builder::resourceDiscoveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDiscoveryStatus").unmarshallLocationName("resourceDiscoveryStatus").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::stateAsString)).setter(IpamResourceDiscoveryAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamResourceDiscoveryAssociation.getter(IpamResourceDiscoveryAssociation::tags)).setter(IpamResourceDiscoveryAssociation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_RESOURCE_DISCOVERY_ASSOCIATION_ID_FIELD, IPAM_RESOURCE_DISCOVERY_ASSOCIATION_ARN_FIELD, IPAM_RESOURCE_DISCOVERY_ID_FIELD, IPAM_ID_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, IS_DEFAULT_FIELD, RESOURCE_DISCOVERY_STATUS_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamResourceDiscoveryAssociationId;
    private final String ipamResourceDiscoveryAssociationArn;
    private final String ipamResourceDiscoveryId;
    private final String ipamId;
    private final String ipamArn;
    private final String ipamRegion;
    private final Boolean isDefault;
    private final String resourceDiscoveryStatus;
    private final String state;
    private final List<Tag> tags;

    private IpamResourceDiscoveryAssociation(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamResourceDiscoveryAssociationId = builder.ipamResourceDiscoveryAssociationId;
        this.ipamResourceDiscoveryAssociationArn = builder.ipamResourceDiscoveryAssociationArn;
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.ipamId = builder.ipamId;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.isDefault = builder.isDefault;
        this.resourceDiscoveryStatus = builder.resourceDiscoveryStatus;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamResourceDiscoveryAssociationId() {
        return this.ipamResourceDiscoveryAssociationId;
    }

    public final String ipamResourceDiscoveryAssociationArn() {
        return this.ipamResourceDiscoveryAssociationArn;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String ipamArn() {
        return this.ipamArn;
    }

    public final String ipamRegion() {
        return this.ipamRegion;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final IpamAssociatedResourceDiscoveryStatus resourceDiscoveryStatus() {
        return IpamAssociatedResourceDiscoveryStatus.fromValue(this.resourceDiscoveryStatus);
    }

    public final String resourceDiscoveryStatusAsString() {
        return this.resourceDiscoveryStatus;
    }

    public final IpamResourceDiscoveryAssociationState state() {
        return IpamResourceDiscoveryAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDiscoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamResourceDiscoveryAssociation)) {
            return false;
        }
        IpamResourceDiscoveryAssociation other = (IpamResourceDiscoveryAssociation)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamResourceDiscoveryAssociationId(), other.ipamResourceDiscoveryAssociationId()) && Objects.equals(this.ipamResourceDiscoveryAssociationArn(), other.ipamResourceDiscoveryAssociationArn()) && Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.ipamArn(), other.ipamArn()) && Objects.equals(this.ipamRegion(), other.ipamRegion()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.resourceDiscoveryStatusAsString(), other.resourceDiscoveryStatusAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"IpamResourceDiscoveryAssociation").add("OwnerId", (Object)this.ownerId()).add("IpamResourceDiscoveryAssociationId", (Object)this.ipamResourceDiscoveryAssociationId()).add("IpamResourceDiscoveryAssociationArn", (Object)this.ipamResourceDiscoveryAssociationArn()).add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("IpamId", (Object)this.ipamId()).add("IpamArn", (Object)this.ipamArn()).add("IpamRegion", (Object)this.ipamRegion()).add("IsDefault", (Object)this.isDefault()).add("ResourceDiscoveryStatus", (Object)this.resourceDiscoveryStatusAsString()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamResourceDiscoveryAssociationId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryAssociationId()));
            }
            case "IpamResourceDiscoveryAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryAssociationArn()));
            }
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "IpamArn": {
                return Optional.ofNullable(clazz.cast(this.ipamArn()));
            }
            case "IpamRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamRegion()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "ResourceDiscoveryStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceDiscoveryStatusAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamResourceDiscoveryAssociation, T> g) {
        return obj -> g.apply((IpamResourceDiscoveryAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamResourceDiscoveryAssociationId;
        private String ipamResourceDiscoveryAssociationArn;
        private String ipamResourceDiscoveryId;
        private String ipamId;
        private String ipamArn;
        private String ipamRegion;
        private Boolean isDefault;
        private String resourceDiscoveryStatus;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamResourceDiscoveryAssociation model) {
            this.ownerId(model.ownerId);
            this.ipamResourceDiscoveryAssociationId(model.ipamResourceDiscoveryAssociationId);
            this.ipamResourceDiscoveryAssociationArn(model.ipamResourceDiscoveryAssociationArn);
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.ipamId(model.ipamId);
            this.ipamArn(model.ipamArn);
            this.ipamRegion(model.ipamRegion);
            this.isDefault(model.isDefault);
            this.resourceDiscoveryStatus(model.resourceDiscoveryStatus);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamResourceDiscoveryAssociationId() {
            return this.ipamResourceDiscoveryAssociationId;
        }

        public final void setIpamResourceDiscoveryAssociationId(String ipamResourceDiscoveryAssociationId) {
            this.ipamResourceDiscoveryAssociationId = ipamResourceDiscoveryAssociationId;
        }

        @Override
        public final Builder ipamResourceDiscoveryAssociationId(String ipamResourceDiscoveryAssociationId) {
            this.ipamResourceDiscoveryAssociationId = ipamResourceDiscoveryAssociationId;
            return this;
        }

        public final String getIpamResourceDiscoveryAssociationArn() {
            return this.ipamResourceDiscoveryAssociationArn;
        }

        public final void setIpamResourceDiscoveryAssociationArn(String ipamResourceDiscoveryAssociationArn) {
            this.ipamResourceDiscoveryAssociationArn = ipamResourceDiscoveryAssociationArn;
        }

        @Override
        public final Builder ipamResourceDiscoveryAssociationArn(String ipamResourceDiscoveryAssociationArn) {
            this.ipamResourceDiscoveryAssociationArn = ipamResourceDiscoveryAssociationArn;
            return this;
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getIpamArn() {
            return this.ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return this.ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getResourceDiscoveryStatus() {
            return this.resourceDiscoveryStatus;
        }

        public final void setResourceDiscoveryStatus(String resourceDiscoveryStatus) {
            this.resourceDiscoveryStatus = resourceDiscoveryStatus;
        }

        @Override
        public final Builder resourceDiscoveryStatus(String resourceDiscoveryStatus) {
            this.resourceDiscoveryStatus = resourceDiscoveryStatus;
            return this;
        }

        @Override
        public final Builder resourceDiscoveryStatus(IpamAssociatedResourceDiscoveryStatus resourceDiscoveryStatus) {
            this.resourceDiscoveryStatus(resourceDiscoveryStatus == null ? null : resourceDiscoveryStatus.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamResourceDiscoveryAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamResourceDiscoveryAssociation build() {
            return new IpamResourceDiscoveryAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamResourceDiscoveryAssociation> {
        public Builder ownerId(String var1);

        public Builder ipamResourceDiscoveryAssociationId(String var1);

        public Builder ipamResourceDiscoveryAssociationArn(String var1);

        public Builder ipamResourceDiscoveryId(String var1);

        public Builder ipamId(String var1);

        public Builder ipamArn(String var1);

        public Builder ipamRegion(String var1);

        public Builder isDefault(Boolean var1);

        public Builder resourceDiscoveryStatus(String var1);

        public Builder resourceDiscoveryStatus(IpamAssociatedResourceDiscoveryStatus var1);

        public Builder state(String var1);

        public Builder state(IpamResourceDiscoveryAssociationState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

