/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SpotPlacementScore;
import software.amazon.awssdk.services.ec2.model.SpotPlacementScoresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSpotPlacementScoresResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetSpotPlacementScoresResponse> {
    private static final SdkField<List<SpotPlacementScore>> SPOT_PLACEMENT_SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotPlacementScores").getter(GetSpotPlacementScoresResponse.getter(GetSpotPlacementScoresResponse::spotPlacementScores)).setter(GetSpotPlacementScoresResponse.setter(Builder::spotPlacementScores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPlacementScoreSet").unmarshallLocationName("spotPlacementScoreSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpotPlacementScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSpotPlacementScoresResponse.getter(GetSpotPlacementScoresResponse::nextToken)).setter(GetSpotPlacementScoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_PLACEMENT_SCORES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SpotPlacementScore> spotPlacementScores;
    private final String nextToken;

    private GetSpotPlacementScoresResponse(BuilderImpl builder) {
        super(builder);
        this.spotPlacementScores = builder.spotPlacementScores;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSpotPlacementScores() {
        return this.spotPlacementScores != null && !(this.spotPlacementScores instanceof SdkAutoConstructList);
    }

    public final List<SpotPlacementScore> spotPlacementScores() {
        return this.spotPlacementScores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpotPlacementScores() ? this.spotPlacementScores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpotPlacementScoresResponse)) {
            return false;
        }
        GetSpotPlacementScoresResponse other = (GetSpotPlacementScoresResponse)((Object)obj);
        return this.hasSpotPlacementScores() == other.hasSpotPlacementScores() && Objects.equals(this.spotPlacementScores(), other.spotPlacementScores()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSpotPlacementScoresResponse").add("SpotPlacementScores", this.hasSpotPlacementScores() ? this.spotPlacementScores() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotPlacementScores": {
                return Optional.ofNullable(clazz.cast(this.spotPlacementScores()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSpotPlacementScoresResponse, T> g) {
        return obj -> g.apply((GetSpotPlacementScoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SpotPlacementScore> spotPlacementScores = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpotPlacementScoresResponse model) {
            super(model);
            this.spotPlacementScores(model.spotPlacementScores);
            this.nextToken(model.nextToken);
        }

        public final List<SpotPlacementScore.Builder> getSpotPlacementScores() {
            List<SpotPlacementScore.Builder> result = SpotPlacementScoresCopier.copyToBuilder(this.spotPlacementScores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpotPlacementScores(Collection<SpotPlacementScore.BuilderImpl> spotPlacementScores) {
            this.spotPlacementScores = SpotPlacementScoresCopier.copyFromBuilder(spotPlacementScores);
        }

        @Override
        public final Builder spotPlacementScores(Collection<SpotPlacementScore> spotPlacementScores) {
            this.spotPlacementScores = SpotPlacementScoresCopier.copy(spotPlacementScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotPlacementScores(SpotPlacementScore ... spotPlacementScores) {
            this.spotPlacementScores(Arrays.asList(spotPlacementScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotPlacementScores(Consumer<SpotPlacementScore.Builder> ... spotPlacementScores) {
            this.spotPlacementScores(Stream.of(spotPlacementScores).map(c -> (SpotPlacementScore)((SpotPlacementScore.Builder)SpotPlacementScore.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSpotPlacementScoresResponse build() {
            return new GetSpotPlacementScoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSpotPlacementScoresResponse> {
        public Builder spotPlacementScores(Collection<SpotPlacementScore> var1);

        public Builder spotPlacementScores(SpotPlacementScore ... var1);

        public Builder spotPlacementScores(Consumer<SpotPlacementScore.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

