/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableAddressTransferRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, EnableAddressTransferRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(EnableAddressTransferRequest.getter(EnableAddressTransferRequest::allocationId)).setter(EnableAddressTransferRequest.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build();
    private static final SdkField<String> TRANSFER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferAccountId").getter(EnableAddressTransferRequest.getter(EnableAddressTransferRequest::transferAccountId)).setter(EnableAddressTransferRequest.setter(Builder::transferAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferAccountId").unmarshallLocationName("TransferAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, TRANSFER_ACCOUNT_ID_FIELD));
    private final String allocationId;
    private final String transferAccountId;

    private EnableAddressTransferRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.transferAccountId = builder.transferAccountId;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String transferAccountId() {
        return this.transferAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAddressTransferRequest)) {
            return false;
        }
        EnableAddressTransferRequest other = (EnableAddressTransferRequest)((Object)obj);
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.transferAccountId(), other.transferAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"EnableAddressTransferRequest").add("AllocationId", (Object)this.allocationId()).add("TransferAccountId", (Object)this.transferAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "TransferAccountId": {
                return Optional.ofNullable(clazz.cast(this.transferAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableAddressTransferRequest, T> g) {
        return obj -> g.apply((EnableAddressTransferRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String allocationId;
        private String transferAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAddressTransferRequest model) {
            super(model);
            this.allocationId(model.allocationId);
            this.transferAccountId(model.transferAccountId);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getTransferAccountId() {
            return this.transferAccountId;
        }

        public final void setTransferAccountId(String transferAccountId) {
            this.transferAccountId = transferAccountId;
        }

        @Override
        public final Builder transferAccountId(String transferAccountId) {
            this.transferAccountId = transferAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableAddressTransferRequest build() {
            return new EnableAddressTransferRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableAddressTransferRequest> {
        public Builder allocationId(String var1);

        public Builder transferAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

