/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailabilitySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledInstanceAvailabilityResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScheduledInstanceAvailabilityResponse.getter(DescribeScheduledInstanceAvailabilityResponse::nextToken)).setter(DescribeScheduledInstanceAvailabilityResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ScheduledInstanceAvailability>> SCHEDULED_INSTANCE_AVAILABILITY_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledInstanceAvailabilitySet").getter(DescribeScheduledInstanceAvailabilityResponse.getter(DescribeScheduledInstanceAvailabilityResponse::scheduledInstanceAvailabilitySet)).setter(DescribeScheduledInstanceAvailabilityResponse.setter(Builder::scheduledInstanceAvailabilitySet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceAvailabilitySet").unmarshallLocationName("scheduledInstanceAvailabilitySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstanceAvailability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEDULED_INSTANCE_AVAILABILITY_SET_FIELD));
    private final String nextToken;
    private final List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

    private DescribeScheduledInstanceAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledInstanceAvailabilitySet = builder.scheduledInstanceAvailabilitySet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasScheduledInstanceAvailabilitySet() {
        return this.scheduledInstanceAvailabilitySet != null && !(this.scheduledInstanceAvailabilitySet instanceof SdkAutoConstructList);
    }

    public final List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        return this.scheduledInstanceAvailabilitySet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledInstanceAvailabilitySet() ? this.scheduledInstanceAvailabilitySet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityResponse)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityResponse other = (DescribeScheduledInstanceAvailabilityResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasScheduledInstanceAvailabilitySet() == other.hasScheduledInstanceAvailabilitySet() && Objects.equals(this.scheduledInstanceAvailabilitySet(), other.scheduledInstanceAvailabilitySet());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScheduledInstanceAvailabilityResponse").add("NextToken", (Object)this.nextToken()).add("ScheduledInstanceAvailabilitySet", this.hasScheduledInstanceAvailabilitySet() ? this.scheduledInstanceAvailabilitySet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScheduledInstanceAvailabilitySet": {
                return Optional.ofNullable(clazz.cast(this.scheduledInstanceAvailabilitySet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledInstanceAvailabilityResponse, T> g) {
        return obj -> g.apply((DescribeScheduledInstanceAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.scheduledInstanceAvailabilitySet(model.scheduledInstanceAvailabilitySet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduledInstanceAvailability.Builder> getScheduledInstanceAvailabilitySet() {
            List<ScheduledInstanceAvailability.Builder> result = ScheduledInstanceAvailabilitySetCopier.copyToBuilder(this.scheduledInstanceAvailabilitySet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability.BuilderImpl> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copyFromBuilder(scheduledInstanceAvailabilitySet);
        }

        @Override
        public final Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copy(scheduledInstanceAvailabilitySet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet(Arrays.asList(scheduledInstanceAvailabilitySet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(Consumer<ScheduledInstanceAvailability.Builder> ... scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet(Stream.of(scheduledInstanceAvailabilitySet).map(c -> (ScheduledInstanceAvailability)((ScheduledInstanceAvailability.Builder)ScheduledInstanceAvailability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeScheduledInstanceAvailabilityResponse build() {
            return new DescribeScheduledInstanceAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> var1);

        public Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... var1);

        public Builder scheduledInstanceAvailabilitySet(Consumer<ScheduledInstanceAvailability.Builder> ... var1);
    }
}

