/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NetworkInterface;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkInterfaceResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateNetworkInterfaceResponse> {
    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterface").getter(CreateNetworkInterfaceResponse.getter(CreateNetworkInterfaceResponse::networkInterface)).setter(CreateNetworkInterfaceResponse.setter(Builder::networkInterface)).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("networkInterface").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateNetworkInterfaceResponse.getter(CreateNetworkInterfaceResponse::clientToken)).setter(CreateNetworkInterfaceResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_FIELD, CLIENT_TOKEN_FIELD));
    private final NetworkInterface networkInterface;
    private final String clientToken;

    private CreateNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterface = builder.networkInterface;
        this.clientToken = builder.clientToken;
    }

    public final NetworkInterface networkInterface() {
        return this.networkInterface;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceResponse)) {
            return false;
        }
        CreateNetworkInterfaceResponse other = (CreateNetworkInterfaceResponse)((Object)obj);
        return Objects.equals(this.networkInterface(), other.networkInterface()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkInterfaceResponse").add("NetworkInterface", (Object)this.networkInterface()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterface": {
                return Optional.ofNullable(clazz.cast(this.networkInterface()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfaceResponse, T> g) {
        return obj -> g.apply((CreateNetworkInterfaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private NetworkInterface networkInterface;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfaceResponse model) {
            super(model);
            this.networkInterface(model.networkInterface);
            this.clientToken(model.clientToken);
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return this.networkInterface != null ? this.networkInterface.toBuilder() : null;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateNetworkInterfaceResponse build() {
            return new CreateNetworkInterfaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkInterfaceResponse> {
        public Builder networkInterface(NetworkInterface var1);

        default public Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return this.networkInterface((NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation(networkInterface)).build());
        }

        public Builder clientToken(String var1);
    }
}

