/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.LinkedHashSet;
import java.util.Map;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;

public class PoiType
extends AbstractPoiType {
    private PoiCategory category;
    private AbstractPoiType parentType;
    private PoiType referenceType;
    private String osmTag;
    private String osmTag2;
    private String osmValue;
    private String osmValue2;
    private String nameTag;
    private boolean text;
    private boolean nameOnly;
    private boolean relation;
    private int order = 90;

    public PoiType(MapPoiTypes poiTypes, PoiCategory category, String name) {
        super(name, poiTypes);
        this.category = category;
    }

    public PoiType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(PoiType referenceType) {
        this.referenceType = referenceType;
    }

    public boolean isReference() {
        return this.referenceType != null;
    }

    public String getOsmTag() {
        if (this.isReference()) {
            return this.referenceType.getOsmTag();
        }
        return this.osmTag;
    }

    public void setOsmTag(String osmTag) {
        this.osmTag = osmTag;
    }

    public String getOsmTag2() {
        if (this.isReference()) {
            return this.referenceType.getOsmTag2();
        }
        return this.osmTag2;
    }

    public void setOsmTag2(String osmTag2) {
        this.osmTag2 = osmTag2;
    }

    public String getOsmValue() {
        if (this.isReference()) {
            return this.referenceType.getOsmValue();
        }
        return this.osmValue;
    }

    public void setOsmValue(String osmValue) {
        this.osmValue = osmValue;
    }

    public String getOsmValue2() {
        if (this.isReference()) {
            return this.referenceType.getOsmValue2();
        }
        return this.osmValue2;
    }

    public void setOsmValue2(String osmValue2) {
        this.osmValue2 = osmValue2;
    }

    public PoiCategory getCategory() {
        return this.category;
    }

    @Override
    public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        LinkedHashSet<String> set;
        PoiType poiType;
        if (this.isAdditional()) {
            return this.parentType.putTypes(acceptedTypes);
        }
        PoiType rt = this.getReferenceType();
        PoiType poiType2 = poiType = rt != null ? rt : this;
        if (!acceptedTypes.containsKey(poiType.category)) {
            acceptedTypes.put(poiType.category, new LinkedHashSet());
        }
        if ((set = acceptedTypes.get(poiType.category)) != null) {
            set.add(poiType.getKeyName());
        }
        return acceptedTypes;
    }

    public void setAdditional(AbstractPoiType parentType) {
        this.parentType = parentType;
    }

    @Override
    public boolean isAdditional() {
        return this.parentType != null;
    }

    public AbstractPoiType getParentType() {
        return this.parentType;
    }

    public boolean isText() {
        return this.text;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public String getNameTag() {
        return this.nameTag;
    }

    public void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public void setNameOnly(boolean nameOnly) {
        this.nameOnly = nameOnly;
    }

    public boolean isRelation() {
        return this.relation;
    }

    public void setRelation(boolean relation) {
        this.relation = relation;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String toString() {
        return "PoiType{category=" + this.category + ", parentType=" + this.parentType + ", referenceType=" + this.referenceType + ", osmTag='" + this.osmTag + '\'' + ", osmTag2='" + this.osmTag2 + '\'' + ", osmValue='" + this.osmValue + '\'' + ", osmValue2='" + this.osmValue2 + '\'' + ", text=" + this.text + ", nameOnly=" + this.nameOnly + ", relation=" + this.relation + ", order=" + this.order + '}';
    }
}

