/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import mediathek.config.StandardLocations;
import mediathek.daten.ListeFilme;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;

public class IndexedFilmList
extends ListeFilme {
    private static final Logger logger = LogManager.getLogger();
    private final StandardAnalyzer analyzer = new StandardAnalyzer();
    private Directory luceneDirectory;
    private IndexWriter writer;
    private DirectoryReader reader;
    private IndexSearcher indexSearcher;

    public IndexedFilmList() {
        try {
            FSDirectory fsDir = FSDirectory.open(StandardLocations.getFilmIndexPath());
            this.luceneDirectory = new NRTCachingDirectory(fsDir, 20.0, 100.0);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            indexWriterConfig.setRAMBufferSizeMB(256.0);
            this.writer = new IndexWriter(this.luceneDirectory, indexWriterConfig);
        }
        catch (Exception ex) {
            logger.error("Creation of Lucene index failed!", (Throwable)ex);
        }
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public void setIndexSearcher(IndexSearcher indexSearcher) {
        this.indexSearcher = indexSearcher;
    }

    public StandardAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public DirectoryReader getReader() {
        return this.reader;
    }

    public void setReader(DirectoryReader reader) {
        this.reader = reader;
    }

    public Directory getLuceneDirectory() {
        return this.luceneDirectory;
    }
}

