/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.filter.FilterComposerDialog;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.presentations.mindmapmode.PresentationState;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeEvent;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeListener;
import org.freeplane.features.presentations.mindmapmode.Slide;
import org.freeplane.features.presentations.mindmapmode.SlideChangeEvent;
import org.freeplane.features.presentations.mindmapmode.SlideChangeListener;
import org.freeplane.features.presentations.mindmapmode.UndoableSlide;

class SlideEditorController {
    private Slide slide;
    private final JToggleButton tglBtnJumpIn;
    private final JButton btnSelectNodes;
    private final JButton btnSetSelectedNodes;
    private final JButton btnAddSelectedNodes;
    private final JButton btnRemoveSelectedNodes;
    private final JToggleButton tglBtnPlaceSelectedNode;
    private final JToggleButton btnAtCenter;
    private final JToggleButton btnOnTheLeft;
    private final JToggleButton btnOnTheRight;
    private final JToggleButton tglBtnChangeZoom;
    private final JLabel lblZoomFactor;
    private final JCheckBox checkBoxShowOnlySelectedNodes;
    private final JCheckBox checkBoxShowAncestors;
    private final JCheckBox checkBoxShowDescendants;
    private final JToggleButton tglbtnSetFilter;
    private final JComponent filterConditionComponentBox;
    private final JToggleButton tglbtnSetFoldingState;
    private final JComponent[] allButtons;
    private final JComponent[] filterRelatedButtons;
    private final SlideChangeListener slideChangeListener;
    private final JComponent filterNotSetLabel;
    private final PresentationState presentationState;
    private FilterComposerDialog filterComposerDialog = null;
    private final JToggleButton[] positionButtons;

    public SlideEditorController(PresentationState presentationState) {
        this.presentationState = presentationState;
        presentationState.addPresentationStateListener(new PresentationStateChangeListener(){

            @Override
            public void onPresentationStateChange(PresentationStateChangeEvent presentationStateChangeEvent) {
                if (presentationStateChangeEvent.eventType == PresentationStateChangeEvent.EventType.PLAYING_STATE_CHANGED) {
                    SlideEditorController.this.updateUI();
                }
            }
        });
        this.tglBtnJumpIn = this.createSetSlideRootButton();
        this.btnSetSelectedNodes = this.createSetSelectedNodeButton();
        this.btnAddSelectedNodes = this.createAddSelectedNodeButton();
        this.btnRemoveSelectedNodes = this.createRemoveSelectedNodeButton();
        this.btnSelectNodes = this.createSelectNodesButton();
        this.tglBtnPlaceSelectedNode = this.createPlacesSelectedNodeToggleButton();
        this.btnOnTheLeft = this.createNodePositionToggleButton("slide.on_the_left", IMapSelection.NodePosition.LEFT);
        this.btnAtCenter = this.createNodePositionToggleButton("slide.at_center", IMapSelection.NodePosition.CENTER);
        this.btnOnTheRight = this.createNodePositionToggleButton("slide.on_the_right", IMapSelection.NodePosition.RIGHT);
        this.positionButtons = new JToggleButton[]{this.btnOnTheLeft, this.btnAtCenter, this.btnOnTheRight};
        this.tglBtnChangeZoom = this.createSetZoomToggleButton();
        this.lblZoomFactor = new JLabel("100 %");
        this.lblZoomFactor.setPreferredSize(this.lblZoomFactor.getPreferredSize());
        this.checkBoxShowOnlySelectedNodes = this.createOnlySelectedNodesCheckBox();
        this.checkBoxShowAncestors = this.createShowAncestorsCheckBox();
        this.checkBoxShowDescendants = this.createShowDescendantsCheckBox();
        this.tglbtnSetFilter = this.createSetFilterToggleButton();
        int minimumHeight = (int)(60.0f * UITools.FONT_SCALE_FACTOR);
        this.filterConditionComponentBox = new Box(0){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                Dimension minimumSize = this.getMinimumSize();
                return new Dimension(Math.max(minimumSize.width, preferredSize.width), Math.max(preferredSize.height, minimumSize.height));
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.filterConditionComponentBox.setMinimumSize(new Dimension(1, minimumHeight));
        this.tglbtnSetFoldingState = this.createSetFoldingStateToggleButton();
        this.allButtons = new JComponent[]{this.btnSelectNodes, this.tglBtnJumpIn, this.btnSetSelectedNodes, this.btnAddSelectedNodes, this.btnRemoveSelectedNodes, this.tglBtnPlaceSelectedNode, this.tglBtnChangeZoom, this.lblZoomFactor, this.checkBoxShowOnlySelectedNodes, this.checkBoxShowAncestors, this.checkBoxShowDescendants, this.tglbtnSetFilter, this.tglbtnSetFoldingState};
        this.filterRelatedButtons = new JComponent[]{this.checkBoxShowAncestors, this.checkBoxShowDescendants};
        this.slideChangeListener = new SlideChangeListener(){

            @Override
            public void onSlideModelChange(SlideChangeEvent changeEvent) {
                SlideEditorController.this.updateUI();
            }
        };
        this.filterNotSetLabel = TranslatedElementFactory.createLabel((String)"slide.nofilter");
        this.filterNotSetLabel.setEnabled(false);
        this.filterNotSetLabel.setForeground(Color.DARK_GRAY);
        this.disableUI();
    }

    private JToggleButton createNodePositionToggleButton(String key, final IMapSelection.NodePosition position) {
        JToggleButton btn = TranslatedElementFactory.createToggleButtonWithIcon((String)(key + ".icon"), (String)(key + ".tooltip"));
        btn.putClientProperty(IMapSelection.NodePosition.class, position);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableSlide.of(SlideEditorController.this.slide).setPlacedNodePosition(position);
            }
        });
        return btn;
    }

    private JToggleButton createSetSlideRootButton() {
        JToggleButton btnSetSlideRoot = TranslatedElementFactory.createToggleButtonWithIcon((String)"SetSlideRoot.icon", (String)"slide.root.tooltip");
        this.configureButton(btnSetSlideRoot);
        btnSetSlideRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String rootNodeId = SlideEditorController.this.slide.getRootNodeId();
                if (rootNodeId == null) {
                    String selection = Controller.getCurrentController().getSelection().getSelected().getID();
                    UndoableSlide.of(SlideEditorController.this.slide).setRootNodeId(selection);
                } else {
                    UndoableSlide.of(SlideEditorController.this.slide).setRootNodeId(null);
                }
            }
        });
        return btnSetSlideRoot;
    }

    private JButton createSetSelectedNodeButton() {
        JButton btnSetSelectedNode = TranslatedElementFactory.createButtonWithIcon((String)"SetSlideContent.icon", (String)"slide.set.tooltip");
        this.configureButton(btnSetSelectedNode);
        btnSetSelectedNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selection = Controller.getCurrentController().getSelection().getOrderedSelectionIds();
                UndoableSlide.of(SlideEditorController.this.slide).setSelectedNodeIds(new LinkedHashSet<String>(selection));
            }
        });
        return btnSetSelectedNode;
    }

    private JButton createAddSelectedNodeButton() {
        JButton btnSetSelectedNode = TranslatedElementFactory.createButtonWithIcon((String)"AddSlideContent.icon", (String)"slide.add.tooltip");
        this.configureButton(btnSetSelectedNode);
        btnSetSelectedNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selection = Controller.getCurrentController().getSelection().getOrderedSelectionIds();
                UndoableSlide.of(SlideEditorController.this.slide).addSelectedNodeIds(selection);
            }
        });
        return btnSetSelectedNode;
    }

    private JButton createRemoveSelectedNodeButton() {
        JButton btnSetSelectedNode = TranslatedElementFactory.createButtonWithIcon((String)"RemoveSlideContent.icon", (String)"slide.remove.tooltip");
        this.configureButton(btnSetSelectedNode);
        btnSetSelectedNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selection = Controller.getCurrentController().getSelection().getOrderedSelectionIds();
                UndoableSlide.of(SlideEditorController.this.slide).removeSelectedNodeIds(selection);
            }
        });
        return btnSetSelectedNode;
    }

    private void configureButton(AbstractButton button) {
        button.setAlignmentX(0.5f);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
    }

    private JToggleButton createSetZoomToggleButton() {
        JToggleButton btnSetsZoom = TranslatedElementFactory.createToggleButtonWithIconAndLabel((String)"SetZoomSlideContent.icon", (String)"slide.setzoom");
        btnSetsZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean changesZoom = !SlideEditorController.this.slide.changesZoom();
                UndoableSlide.of(SlideEditorController.this.slide).setChangesZoom(changesZoom);
                if (changesZoom) {
                    UndoableSlide.of(SlideEditorController.this.slide).setZoom(Controller.getCurrentController().getMapViewManager().getZoom());
                }
            }
        });
        return btnSetsZoom;
    }

    private JToggleButton createPlacesSelectedNodeToggleButton() {
        final JToggleButton checkBoxOnlySpecificNodes = TranslatedElementFactory.createToggleButtonWithIconAndLabel((String)"PlaceSelectedNodeOnSlide.icon", (String)"slide.placenode");
        this.configureButton(checkBoxOnlySpecificNodes);
        checkBoxOnlySpecificNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String centeredNodeId = SlideEditorController.this.slide.getPlacedNodeId();
                IMapSelection selection = Controller.getCurrentController().getSelection();
                if (centeredNodeId == null) {
                    NodeModel selected = selection.getSelected();
                    if (selected != null) {
                        UndoableSlide.of(SlideEditorController.this.slide).setPlacedNodeId(selected.getID());
                        SlideEditorController.this.setNodePlacementControlsEnabled(true, SlideEditorController.this.slide.getPlacedNodePosition());
                    } else {
                        UndoableSlide.of(SlideEditorController.this.slide).setPlacedNodeId(null);
                        SlideEditorController.this.setNodePlacementControlsEnabled(false, SlideEditorController.this.slide.getPlacedNodePosition());
                    }
                } else {
                    UndoableSlide.of(SlideEditorController.this.slide).setPlacedNodeId(null);
                    SlideEditorController.this.setNodePlacementControlsEnabled(false, SlideEditorController.this.slide.getPlacedNodePosition());
                    MapModel map = Controller.getCurrentController().getMap();
                    NodeModel node = map.getNodeForID(centeredNodeId);
                    if (node != null) {
                        selection.selectAsTheOnlyOneSelected(node);
                    }
                }
                checkBoxOnlySpecificNodes.setSelected(SlideEditorController.this.slide.getPlacedNodeId() != null);
            }
        });
        return checkBoxOnlySpecificNodes;
    }

    private JCheckBox createOnlySelectedNodesCheckBox() {
        JCheckBox checkBoxOnlySpecificNodes = TranslatedElementFactory.createCheckBox((String)"slide.showonlyselected");
        checkBoxOnlySpecificNodes.setAlignmentX(0.5f);
        checkBoxOnlySpecificNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableSlide.of(SlideEditorController.this.slide).setShowsOnlySpecificNodes(!SlideEditorController.this.slide.showsOnlySpecificNodes());
            }
        });
        return checkBoxOnlySpecificNodes;
    }

    private JCheckBox createShowAncestorsCheckBox() {
        JCheckBox checkBoxShowAncestors = TranslatedElementFactory.createCheckBox((String)"slide.showancestors");
        checkBoxShowAncestors.setAlignmentX(0.5f);
        checkBoxShowAncestors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableSlide.of(SlideEditorController.this.slide).setShowsAncestors(!SlideEditorController.this.slide.showsAncestors());
            }
        });
        return checkBoxShowAncestors;
    }

    private JCheckBox createShowDescendantsCheckBox() {
        JCheckBox checkBoxShowDescendants = TranslatedElementFactory.createCheckBox((String)"slide.descendants");
        checkBoxShowDescendants.setAlignmentX(0.5f);
        checkBoxShowDescendants.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableSlide.of(SlideEditorController.this.slide).setShowsDescendants(!SlideEditorController.this.slide.showsDescendants());
            }
        });
        return checkBoxShowDescendants;
    }

    private JToggleButton createSetFilterToggleButton() {
        final JToggleButton tglbtnSetFilter = TranslatedElementFactory.createToggleButtonWithIconAndLabel((String)"SetFilterSlideContent.icon", (String)"slide.setfilter");
        this.configureButton(tglbtnSetFilter);
        tglbtnSetFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ASelectableCondition oldCondition;
                if (SlideEditorController.this.filterComposerDialog == null) {
                    SlideEditorController.this.filterComposerDialog = new FilterComposerDialog(FilterConditionEditor.Variant.FILTER_COMPOSER);
                }
                if ((oldCondition = SlideEditorController.this.slide.getFilterCondition()) != null) {
                    SlideEditorController.this.filterComposerDialog.addCondition(oldCondition);
                    SlideEditorController.this.filterComposerDialog.setSelectedItem((Object)oldCondition);
                    UndoableSlide.of(SlideEditorController.this.slide).setFilterCondition(null);
                } else {
                    SlideEditorController.this.filterComposerDialog.show();
                    List conditions = SlideEditorController.this.filterComposerDialog.getConditions();
                    if (SlideEditorController.this.filterComposerDialog.isSuccess()) {
                        ASelectableCondition newCondition = conditions.isEmpty() ? null : (ASelectableCondition)conditions.get(0);
                        UndoableSlide.of(SlideEditorController.this.slide).setFilterCondition(newCondition);
                    }
                }
                tglbtnSetFilter.setSelected(SlideEditorController.this.slide.getFilterCondition() != null);
            }
        });
        return tglbtnSetFilter;
    }

    private JButton createSelectNodesButton() {
        JButton btnHighlightSlideContent = TranslatedElementFactory.createButtonWithIcon((String)"SelectSlideContent.icon", (String)"slide.select.tooltip");
        this.configureButton(btnHighlightSlideContent);
        btnHighlightSlideContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlideEditorController.this.slide.replaceCurrentSelection();
            }
        });
        return btnHighlightSlideContent;
    }

    private JToggleButton createSetFoldingStateToggleButton() {
        JToggleButton tglbtnSetFilter = TranslatedElementFactory.createToggleButtonWithIconAndLabel((String)"SetFoldingSlideContent.icon", (String)"slide.setfoldingstate");
        this.configureButton(tglbtnSetFilter);
        tglbtnSetFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SlideEditorController.this.slide.foldsNodes()) {
                    UndoableSlide.of(SlideEditorController.this.slide).setCurrentFoldedNodeIDs();
                } else {
                    UndoableSlide.of(SlideEditorController.this.slide).unsetFoldsNodes();
                }
            }
        });
        return tglbtnSetFilter;
    }

    Box createSlideContentBox() {
        Box content = Box.createVerticalBox();
        content.setName("!!!!");
        Box selectionBox = Box.createHorizontalBox();
        selectionBox.add(this.tglBtnJumpIn);
        selectionBox.add(this.btnSetSelectedNodes);
        selectionBox.add(this.btnAddSelectedNodes);
        selectionBox.add(this.btnRemoveSelectedNodes);
        selectionBox.add(this.btnSelectNodes);
        content.add(selectionBox);
        int gap = this.tglBtnPlaceSelectedNode.getPreferredSize().height / 2;
        content.add(Box.createVerticalStrut(gap));
        content.add(this.tglBtnPlaceSelectedNode);
        Box positionBox = Box.createHorizontalBox();
        positionBox.add(this.btnOnTheLeft);
        positionBox.add(this.btnAtCenter);
        positionBox.add(this.btnOnTheRight);
        content.add(positionBox);
        content.add(Box.createVerticalStrut(gap));
        Box zoomBox = Box.createHorizontalBox();
        zoomBox.add(this.tglBtnChangeZoom);
        zoomBox.add(this.lblZoomFactor);
        content.add(zoomBox);
        content.add(this.checkBoxShowOnlySelectedNodes);
        content.add(this.checkBoxShowAncestors);
        content.add(this.checkBoxShowDescendants);
        content.add(this.tglbtnSetFilter);
        content.add(this.filterConditionComponentBox);
        this.filterConditionComponentBox.setAlignmentX(0.5f);
        TranslatedElementFactory.createTitledBorder((JComponent)this.filterConditionComponentBox, (String)"slide.filter");
        content.add(this.tglbtnSetFoldingState);
        Box contentWithMargins = Box.createHorizontalBox();
        TranslatedElementFactory.createTitledBorder((JComponent)contentWithMargins, (String)"slide.content");
        contentWithMargins.add(Box.createHorizontalGlue());
        contentWithMargins.add(content);
        contentWithMargins.add(Box.createHorizontalGlue());
        return contentWithMargins;
    }

    public void setSlide(Slide newSlide) {
        if (this.slide != null) {
            this.slide.removeSlideChangeListener(this.slideChangeListener);
        }
        this.slide = newSlide;
        this.updateUI();
        if (newSlide != null) {
            this.slide.addSlideChangeListener(this.slideChangeListener);
        }
    }

    private void disableUI() {
        for (JComponent c : this.allButtons) {
            c.setEnabled(false);
        }
        this.setNodePlacementControlsEnabled(false, null);
        this.updateFilter();
    }

    private void updateUI() {
        if (this.slide == null) {
            this.disableUI();
            this.tglBtnJumpIn.setSelected(false);
            this.checkBoxShowOnlySelectedNodes.setSelected(false);
            this.tglBtnPlaceSelectedNode.setSelected(false);
            this.tglBtnChangeZoom.setSelected(false);
            this.lblZoomFactor.setText("");
            this.checkBoxShowOnlySelectedNodes.setSelected(false);
            this.checkBoxShowAncestors.setSelected(false);
            this.checkBoxShowDescendants.setSelected(false);
            this.checkBoxShowAncestors.setSelected(false);
            this.tglbtnSetFilter.setSelected(false);
        } else {
            for (JComponent c : this.allButtons) {
                c.setEnabled(true);
            }
            boolean showsOnlySpecificNodes = this.slide.showsOnlySpecificNodes();
            this.checkBoxShowOnlySelectedNodes.setSelected(showsOnlySpecificNodes);
            boolean jumpsIn = this.slide.getRootNodeId() != null;
            this.tglBtnJumpIn.setSelected(jumpsIn);
            boolean placesSelectedNode = this.slide.getPlacedNodeId() != null;
            this.tglBtnPlaceSelectedNode.setSelected(placesSelectedNode);
            this.setNodePlacementControlsEnabled(placesSelectedNode, this.slide.getPlacedNodePosition());
            ASelectableCondition filterCondition = this.slide.getFilterCondition();
            if (!this.presentationState.isPresentationRunning()) {
                for (JComponent c : this.filterRelatedButtons) {
                    c.setEnabled(showsOnlySpecificNodes || filterCondition != null);
                }
            }
            boolean changesZoom = this.slide.changesZoom();
            this.tglBtnChangeZoom.setSelected(changesZoom);
            this.lblZoomFactor.setText(changesZoom ? Math.round(this.slide.getZoom() * 100.0f) + "%" : "");
            this.checkBoxShowOnlySelectedNodes.setSelected(showsOnlySpecificNodes);
            this.checkBoxShowAncestors.setSelected(this.slide.showsAncestors());
            this.checkBoxShowDescendants.setSelected(this.slide.showsDescendants());
            this.checkBoxShowAncestors.setSelected(this.slide.showsAncestors());
            this.tglbtnSetFilter.setSelected(filterCondition != null);
            this.tglbtnSetFoldingState.setSelected(this.slide.foldsNodes());
        }
        this.updateFilter();
    }

    private void updateFilter() {
        ASelectableCondition filterCondition;
        this.removeFilterComponent();
        ASelectableCondition aSelectableCondition = filterCondition = this.slide != null ? this.slide.getFilterCondition() : null;
        if (filterCondition != null) {
            JComponent component = filterCondition.createGraphicComponent();
            this.filterConditionComponentBox.add(component);
        } else {
            this.filterConditionComponentBox.add(this.filterNotSetLabel);
        }
        this.filterConditionComponentBox.revalidate();
    }

    private void removeFilterComponent() {
        while (this.filterConditionComponentBox.getComponentCount() > 0) {
            this.filterConditionComponentBox.remove(0);
        }
    }

    private void setNodePlacementControlsEnabled(boolean placesSelectedNode, IMapSelection.NodePosition nodePosition) {
        for (JToggleButton btn : this.positionButtons) {
            btn.setEnabled(placesSelectedNode);
            btn.setSelected(placesSelectedNode && nodePosition == btn.getClientProperty(IMapSelection.NodePosition.class));
        }
    }
}

