"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findPluginRouting = exports.findDocumentation = void 0;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const yaml_1 = require("yaml");
const docsParser_1 = require("./docsParser");
const pathUtils_1 = require("./pathUtils");
function findDocumentation(dir, kind) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!fs.existsSync(dir) || fs.lstatSync(dir).isFile()) {
            return [];
        }
        let files;
        switch (kind) {
            case "builtin":
                files = yield (0, pathUtils_1.globArray)([`${dir}/**/*.py`, "!/**/_*.py"]);
                break;
            case "builtin_doc_fragment":
                files = yield (0, pathUtils_1.globArray)([
                    `${path.resolve(dir, "../")}/plugins/doc_fragments/*.py`,
                    "!/**/_*.py",
                ]);
                break;
            case "collection":
                files = yield (0, pathUtils_1.globArray)([
                    `${dir}/ansible_collections/*/*/plugins/modules/*.py`,
                    `${dir}/ansible_collections/*/*/plugins/modules/**/*.py`,
                    `!${dir}/ansible_collections/*/*/plugins/modules/_*.py`,
                    `!${dir}/ansible_collections/*/*/plugins/modules/**/_*.py`,
                ]).filter((item) => !fs.lstatSync(item).isSymbolicLink());
                break;
            case "collection_doc_fragment":
                files = yield (0, pathUtils_1.globArray)([
                    `${dir}/ansible_collections/*/*/plugins/doc_fragments/*.py`,
                    `!${dir}/ansible_collections/*/*/plugins/doc_fragments/_*.py`,
                ]);
                break;
        }
        return files.map((file) => {
            const name = path.basename(file, ".py");
            let namespace;
            let collection;
            switch (kind) {
                case "builtin":
                case "builtin_doc_fragment":
                    namespace = "ansible";
                    collection = "builtin";
                    break;
                case "collection":
                case "collection_doc_fragment":
                    const pathArray = file.split(path.sep);
                    const pluginsDirIndex = pathArray.indexOf("plugins");
                    namespace = pathArray[pluginsDirIndex - 2];
                    collection = pathArray[pluginsDirIndex - 1];
                    if (pathArray.length > pluginsDirIndex + 3) {
                        const subCollectionArray = pathArray.slice(pluginsDirIndex + 2, pathArray.length - 1);
                        collection = `${collection}.${subCollectionArray.join(".")}`;
                    }
                    break;
            }
            return new docsParser_1.LazyModuleDocumentation(file, `${namespace}.${collection}.${name}`, namespace, collection, name);
        });
    });
}
exports.findDocumentation = findDocumentation;
function findPluginRouting(dir, kind) {
    return __awaiter(this, void 0, void 0, function* () {
        const pluginRouting = new Map();
        if (!fs.existsSync(dir) || fs.lstatSync(dir).isFile()) {
            return pluginRouting;
        }
        let files;
        switch (kind) {
            case "builtin":
                files = yield (0, pathUtils_1.globArray)([`${dir}/config/ansible_builtin_runtime.yml`]);
                break;
            case "collection":
                files = yield (0, pathUtils_1.globArray)([
                    `${dir}/ansible_collections/*/*/meta/runtime.yml`,
                ]);
                break;
        }
        for (const file of files) {
            let collection;
            switch (kind) {
                case "builtin":
                    collection = "ansible.builtin";
                    break;
                case "collection":
                    const pathArray = file.split(path.sep);
                    collection = `${pathArray[pathArray.length - 4]}.${pathArray[pathArray.length - 3]}`;
                    break;
            }
            const runtimeContent = yield fs.promises.readFile(file, {
                encoding: "utf8",
            });
            const document = (0, yaml_1.parseDocument)(runtimeContent).toJSON();
            pluginRouting.set(collection, (0, docsParser_1.parseRawRouting)(document));
        }
        return pluginRouting;
    });
}
exports.findPluginRouting = findPluginRouting;
//# sourceMappingURL=docsFinder.js.map