/*************************************************************************/
/*                                                                       */
/*                  Language Technologies Institute                      */
/*                     Carnegie Mellon University                        */
/*                        Copyright (c) 2001                             */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission is hereby granted, free of charge, to use and distribute  */
/*  this software and its documentation without restriction, including   */
/*  without limitation the rights to use, copy, modify, merge, publish,  */
/*  distribute, sublicense, and/or sell copies of this work, and to      */
/*  permit persons to whom this work is furnished to do so, subject to   */
/*  the following conditions:                                            */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*   4. The authors' names are not used to endorse or promote products   */
/*      derived from this software without specific prior written        */
/*      permission.                                                      */
/*                                                                       */
/*  CARNEGIE MELLON UNIVERSITY AND THE CONTRIBUTORS TO THIS WORK         */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL CARNEGIE MELLON UNIVERSITY NOR THE CONTRIBUTORS BE LIABLE      */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author:  Alan W Black (awb@cs.cmu.edu)                    */
/*               Date:  January 2001                                     */
/*************************************************************************/
/*                                                                       */
/*  Signal processing                                                    */
/*                                                                       */
/*************************************************************************/
#ifndef _CST_SIGPR_H__
#define _CST_SIGPR_H__

#include "cst_file.h"
#include "cst_val.h"
#include "cst_sts.h"

cst_wave *lpc_resynth(cst_lpcres *lpcres);
cst_wave *lpc_resynth_fixedpoint(cst_lpcres *lpcres);
cst_wave *lpc_resynth_spike(cst_lpcres *lpcres);

void add_residual_windowed(int targ_size,
                           unsigned char *targ_residual,
                           int unit_size, const unsigned char *unit_residual);
void add_residual_g721(int targ_size, unsigned char *targ_residual,
                       int packed_unit_size,
                       const unsigned char *unit_residual);
void add_residual_g721vuv(int targ_size, unsigned char *targ_residual,
                          int uunit_size, const unsigned char *unit_residual);
void add_residual_vuv(int targ_size, unsigned char *targ_residual,
                      int packed_unit_size,
                      const unsigned char *unit_residual);

#endif
