/*
 * Copyright (C) 2021-2022 Chupligin Sergey <neochapay@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#include <QNetworkReply>
#include <QObject>

class Downloader : public QObject {
    Q_OBJECT
public:
    explicit Downloader(QString urlString, QObject* parent = 0);

signals:
    void stringReady(QByteArray answer);
    void urlNotValid();
    void downloadProgress(float progress);

public slots:
    void loadData();

private slots:
    void dataReady(QNetworkReply* reply);
    void onDownloadProgress(qint64 bytesRead, qint64 bytesTotal);

private:
    QNetworkReply* m_response;
    QNetworkAccessManager* m_manager;
    QUrl m_url;
};

#endif // DOWNLOADER_H
