# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestCase message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # A `TestCase` contains a sequence of `TestStep`s.
    ##
    class TestCase < Message
      attr_reader :id

      ##
      # The ID of the `Pickle` this `TestCase` is derived from.
      ##
      attr_reader :pickle_id

      attr_reader :test_steps

      ##
      # Identifier for the test run that this test case belongs to
      ##
      attr_reader :test_run_started_id

      def initialize(
        id: '',
        pickle_id: '',
        test_steps: [],
        test_run_started_id: nil
      )
        @id = id
        @pickle_id = pickle_id
        @test_steps = test_steps
        @test_run_started_id = test_run_started_id
        super()
      end

      ##
      # Returns a new TestCase from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestCase.from_h(some_hash) # => #<Cucumber::Messages::TestCase:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          id: hash[:id],
          pickle_id: hash[:pickleId],
          test_steps: hash[:testSteps]&.map { |item| TestStep.from_h(item) },
          test_run_started_id: hash[:testRunStartedId]
        )
      end
    end
  end
end
