# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Simon Ser
# Copyright © 2019 Ivan Molodetskikh
# Copyright © 2024 Neal Gompa
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSeat
from .ext_data_control_device_v1 import ExtDataControlDeviceV1
from .ext_data_control_source_v1 import ExtDataControlSourceV1


class ExtDataControlManagerV1(Interface):
    """Manager to control data devices

    This interface is a manager that allows creating per-seat data device
    controls.
    """

    name = "ext_data_control_manager_v1"
    version = 1


class ExtDataControlManagerV1Proxy(Proxy[ExtDataControlManagerV1]):
    interface = ExtDataControlManagerV1

    @ExtDataControlManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtDataControlSourceV1),
    )
    def create_data_source(self) -> Proxy[ExtDataControlSourceV1]:
        """Create a new data source

        Create a new data source.

        :returns:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlSourceV1`
            -- data source to create
        """
        id = self._marshal_constructor(0, ExtDataControlSourceV1)
        return id

    @ExtDataControlManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtDataControlDeviceV1),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def get_data_device(self, seat: WlSeat) -> Proxy[ExtDataControlDeviceV1]:
        """Get a data device for a seat

        Create a data device that can be used to manage a seat's selection.

        :param seat:
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlDeviceV1`
        """
        id = self._marshal_constructor(1, ExtDataControlDeviceV1, seat)
        return id

    @ExtDataControlManagerV1.request()
    def destroy(self) -> None:
        """Destroy the manager

        All objects created by the manager will still remain valid, until their
        appropriate destroy request has been called.
        """
        self._marshal(2)
        self._destroy()


class ExtDataControlManagerV1Resource(Resource):
    interface = ExtDataControlManagerV1


class ExtDataControlManagerV1Global(Global):
    interface = ExtDataControlManagerV1


ExtDataControlManagerV1._gen_c()
ExtDataControlManagerV1.proxy_class = ExtDataControlManagerV1Proxy
ExtDataControlManagerV1.resource_class = ExtDataControlManagerV1Resource
ExtDataControlManagerV1.global_class = ExtDataControlManagerV1Global
