# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Simon Ser
# Copyright © 2019 Ivan Molodetskikh
# Copyright © 2024 Neal Gompa
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .ext_data_control_offer_v1 import ExtDataControlOfferV1
from .ext_data_control_source_v1 import ExtDataControlSourceV1


class ExtDataControlDeviceV1(Interface):
    """Manage a data device for a seat

    This interface allows a client to manage a seat's selection.

    When the seat is destroyed, this object becomes inert.
    """

    name = "ext_data_control_device_v1"
    version = 1

    class error(enum.IntEnum):
        used_source = 1


class ExtDataControlDeviceV1Proxy(Proxy[ExtDataControlDeviceV1]):
    interface = ExtDataControlDeviceV1

    @ExtDataControlDeviceV1.request(
        Argument(ArgumentType.Object, interface=ExtDataControlSourceV1, nullable=True),
    )
    def set_selection(self, source: ExtDataControlSourceV1 | None) -> None:
        """Copy data to the selection

        This request asks the compositor to set the selection to the data from
        the source on behalf of the client.

        The given source may not be used in any further set_selection or
        set_primary_selection requests. Attempting to use a previously used
        source triggers the used_source protocol error.

        To unset the selection, set the source to NULL.

        :param source:
        :type source:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlSourceV1` or `None`
        """
        self._marshal(0, source)

    @ExtDataControlDeviceV1.request()
    def destroy(self) -> None:
        """Destroy this data device

        Destroys the data device object.
        """
        self._marshal(1)
        self._destroy()

    @ExtDataControlDeviceV1.request(
        Argument(ArgumentType.Object, interface=ExtDataControlSourceV1, nullable=True),
    )
    def set_primary_selection(self, source: ExtDataControlSourceV1 | None) -> None:
        """Copy data to the primary selection

        This request asks the compositor to set the primary selection to the
        data from the source on behalf of the client.

        The given source may not be used in any further set_selection or
        set_primary_selection requests. Attempting to use a previously used
        source triggers the used_source protocol error.

        To unset the primary selection, set the source to NULL.

        The compositor will ignore this request if it does not support primary
        selection.

        :param source:
        :type source:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlSourceV1` or `None`
        """
        self._marshal(2, source)


class ExtDataControlDeviceV1Resource(Resource):
    interface = ExtDataControlDeviceV1

    @ExtDataControlDeviceV1.event(
        Argument(ArgumentType.NewId, interface=ExtDataControlOfferV1),
    )
    def data_offer(self, id: ExtDataControlOfferV1) -> None:
        """Introduce a new ext_data_control_offer

        The data_offer event introduces a new ext_data_control_offer object,
        which will subsequently be used in either the
        ext_data_control_device.selection event (for the regular clipboard
        selections) or the ext_data_control_device.primary_selection event (for
        the primary clipboard selections). Immediately following the
        ext_data_control_device.data_offer event, the new data_offer object
        will send out ext_data_control_offer.offer events to describe the MIME
        types it offers.

        :param id:
        :type id:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlOfferV1`
        """
        self._post_event(0, id)

    @ExtDataControlDeviceV1.event(
        Argument(ArgumentType.Object, interface=ExtDataControlOfferV1, nullable=True),
    )
    def selection(self, id: ExtDataControlOfferV1 | None) -> None:
        """Advertise new selection

        The selection event is sent out to notify the client of a new
        ext_data_control_offer for the selection for this device. The
        ext_data_control_device.data_offer and the ext_data_control_offer.offer
        events are sent out immediately before this event to introduce the data
        offer object. The selection event is sent to a client when a new
        selection is set. The ext_data_control_offer is valid until a new
        ext_data_control_offer or NULL is received. The client must destroy the
        previous selection ext_data_control_offer, if any, upon receiving this
        event. Regardless, the previous selection will be ignored once a new
        selection ext_data_control_offer is received.

        The first selection event is sent upon binding the
        ext_data_control_device object.

        :param id:
        :type id:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlOfferV1` or `None`
        """
        self._post_event(1, id)

    @ExtDataControlDeviceV1.event()
    def finished(self) -> None:
        """This data control is no longer valid

        This data control object is no longer valid and should be destroyed by
        the client.
        """
        self._post_event(2)

    @ExtDataControlDeviceV1.event(
        Argument(ArgumentType.Object, interface=ExtDataControlOfferV1, nullable=True),
    )
    def primary_selection(self, id: ExtDataControlOfferV1 | None) -> None:
        """Advertise new primary selection

        The primary_selection event is sent out to notify the client of a new
        ext_data_control_offer for the primary selection for this device. The
        ext_data_control_device.data_offer and the ext_data_control_offer.offer
        events are sent out immediately before this event to introduce the data
        offer object. The primary_selection event is sent to a client when a
        new primary selection is set. The ext_data_control_offer is valid until
        a new ext_data_control_offer or NULL is received. The client must
        destroy the previous primary selection ext_data_control_offer, if any,
        upon receiving this event. Regardless, the previous primary selection
        will be ignored once a new primary selection ext_data_control_offer is
        received.

        If the compositor supports primary selection, the first
        primary_selection event is sent upon binding the
        ext_data_control_device object.

        :param id:
        :type id:
            :class:`~pywayland.protocol.ext_data_control_v1.ExtDataControlOfferV1` or `None`
        """
        self._post_event(3, id)


class ExtDataControlDeviceV1Global(Global):
    interface = ExtDataControlDeviceV1


ExtDataControlDeviceV1._gen_c()
ExtDataControlDeviceV1.proxy_class = ExtDataControlDeviceV1Proxy
ExtDataControlDeviceV1.resource_class = ExtDataControlDeviceV1Resource
ExtDataControlDeviceV1.global_class = ExtDataControlDeviceV1Global
