/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Optional;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.FieldExtractor;

public class IndexExtractor
implements FieldExtractor<Long> {
    @Config(description="The metadata key to emit, defaults to Example.NAME")
    private String metadataName = "name";

    public IndexExtractor(String metadataName) {
        this.metadataName = metadataName;
    }

    public IndexExtractor() {
    }

    @Override
    public String getMetadataName() {
        return this.metadataName;
    }

    @Override
    public Class<Long> getValueType() {
        return Long.class;
    }

    @Override
    public Optional<Long> extract(ColumnarIterator.Row row) {
        return row.getIndex() == -1L ? Optional.empty() : Optional.of(row.getIndex());
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "IndexExtractor");
    }
}

