/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateClose;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateDelete;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateForceMerge;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateIndexPriority;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateNothing;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateOpen;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateReadOnly;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateReadWrite;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateReplicaCount;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateRollover;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateSnapshot;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateTransition;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ValidationResult;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

@OpenForTesting
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ActionValidation;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getJvmService", "()Lorg/opensearch/monitor/jvm/JvmService;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "validate", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ValidationResult;", "actionName", "", "indexName", "opensearch-index-management"})
public class ActionValidation {
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final JvmService jvmService;

    public ActionValidation(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        this.settings = settings;
        this.clusterService = clusterService;
        this.jvmService = jvmService;
    }

    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public JvmService getJvmService() {
        return this.jvmService;
    }

    @NotNull
    public ValidationResult validate(@NotNull String actionName, @NotNull String indexName) {
        Validate validate2;
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        switch (actionName) {
            case "rollover": {
                validate2 = new ValidateRollover(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "delete": {
                validate2 = new ValidateDelete(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "force_merge": {
                validate2 = new ValidateForceMerge(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "open": {
                validate2 = new ValidateOpen(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "read_only": {
                validate2 = new ValidateReadOnly(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "read_write": {
                validate2 = new ValidateReadWrite(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "replica_count": {
                validate2 = new ValidateReplicaCount(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "snapshot": {
                validate2 = new ValidateSnapshot(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "transition": {
                validate2 = new ValidateTransition(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "close": {
                validate2 = new ValidateClose(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "index_priority": {
                validate2 = new ValidateIndexPriority(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "notification": {
                validate2 = new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "shrink": {
                validate2 = new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "allocation": {
                validate2 = new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            case "rollup": {
                validate2 = new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
                break;
            }
            default: {
                validate2 = new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            }
        }
        Validate validation = validate2;
        return new ValidationResult(String.valueOf(validation.getValidationMessage()), validation.getValidationStatus());
    }
}

