/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class TaginfoAction
extends AbstractAction {
    private static final StringProperty TAGINFO_URL_PROP = new StringProperty("taginfo.url", "https://taginfo.openstreetmap.org/");
    private static final StringProperty TAG_HISTORY_URL_PROP = new StringProperty("taghistory.url", "https://taghistory.raifer.tech/#***");
    private final Supplier<Tag> tagSupplier;
    private final Supplier<String> relationTypeSupplier;
    protected final String taginfoUrl;

    private TaginfoAction(String name, Supplier<Tag> tagSupplier, Supplier<String> relationTypeSupplier, String taginfoUrl) {
        super(name);
        this.tagSupplier = Objects.requireNonNull(tagSupplier);
        this.relationTypeSupplier = Objects.requireNonNull(relationTypeSupplier);
        this.taginfoUrl = TaginfoAction.withoutTrailingSlash(Objects.requireNonNull(taginfoUrl));
    }

    public TaginfoAction(Supplier<Tag> tagSupplier, Supplier<String> relationTypeSupplier) {
        this(I18n.tr("Go to Taginfo", new Object[0]), tagSupplier, relationTypeSupplier, TAGINFO_URL_PROP.get());
        new ImageProvider("dialogs/taginfo").getResource().attachImageIcon(this, true);
    }

    public TaginfoAction(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier, JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier) {
        this(TaginfoAction.getTagSupplier(tagTable, tagKeySupplier, tagValuesSupplier), TaginfoAction.getRelationTypeSupplier(membershipTable, memberValueSupplier));
    }

    private static Supplier<Tag> getTagSupplier(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier) {
        Objects.requireNonNull(tagTable);
        Objects.requireNonNull(tagKeySupplier);
        Objects.requireNonNull(tagValuesSupplier);
        return () -> {
            if (tagTable.getSelectedRowCount() == 1) {
                int row = tagTable.getSelectedRow();
                String key = (String)tagKeySupplier.apply(row);
                Map values = (Map)tagValuesSupplier.apply(row);
                String value = values.size() == 1 ? (String)values.keySet().iterator().next() : null;
                return new Tag(key, value);
            }
            return null;
        };
    }

    private static Supplier<String> getRelationTypeSupplier(JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier) {
        return () -> membershipTable != null && membershipTable.getSelectedRowCount() == 1 ? ((IRelation)memberValueSupplier.apply(membershipTable.getSelectedRow())).get("type") : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Tag tag = this.tagSupplier.get();
        if (tag != null) {
            OpenBrowser.displayUrl(this.getTaginfoUrlForTag(tag));
            return;
        }
        String type = this.relationTypeSupplier.get();
        if (type != null) {
            OpenBrowser.displayUrl(this.getTaginfoUrlForRelationType(type));
        }
    }

    private static String withoutTrailingSlash(String url) {
        return Utils.strip(url, "/");
    }

    public String getTaginfoUrlForTag(Tag tag) {
        if (tag.getValue().isEmpty()) {
            return this.taginfoUrl + "/keys/" + TaginfoAction.encodeKeyValue(tag.getKey());
        }
        return this.taginfoUrl + "/tags/" + TaginfoAction.encodeKeyValue(tag.getKey()) + "=" + TaginfoAction.encodeKeyValue(tag.getValue());
    }

    private static String encodeKeyValue(String string) {
        return Utils.encodeUrl(string).replaceAll("\\+", "%20");
    }

    public String getTaginfoUrlForRelationType(String type) {
        return this.taginfoUrl + "/relations/" + type;
    }

    public TaginfoAction withTaginfoUrl(String name, String taginfoUrl) {
        TaginfoAction action = new TaginfoAction(name, this.tagSupplier, this.relationTypeSupplier, taginfoUrl);
        new ImageProvider("dialogs/taginfo").getResource().attachImageIcon(action, true);
        return action;
    }

    public TaginfoAction toTagHistoryAction() {
        String url = TAG_HISTORY_URL_PROP.get();
        TaginfoAction action = new TaginfoAction(I18n.tr("Go to OSM Tag History", new Object[0]), this.tagSupplier, this.relationTypeSupplier, url){

            @Override
            public String getTaginfoUrlForTag(Tag tag) {
                return String.join((CharSequence)"/", this.taginfoUrl, tag.getKey(), tag.getValue());
            }

            @Override
            public String getTaginfoUrlForRelationType(String type) {
                return null;
            }
        };
        new ImageProvider("dialogs/taghistory").getResource().attachImageIcon(action, true);
        return action;
    }
}

