/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class AbstractNodesCommand<C extends Collection<Node>>
extends Command {
    protected final Way way;
    protected final C cmdNodes;

    protected AbstractNodesCommand(Way way, C cmdNodes) {
        this(way.getDataSet(), way, cmdNodes);
    }

    protected AbstractNodesCommand(DataSet ds, Way way, C cmdNodes) {
        super(ds);
        this.way = Objects.requireNonNull(way, "way");
        this.cmdNodes = (Collection)Objects.requireNonNull(cmdNodes, "cmdNodes");
        if (cmdNodes.isEmpty()) {
            throw new IllegalArgumentException("Nodes collection is empty");
        }
    }

    protected abstract void modifyWay();

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.modifyWay();
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.way);
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(OsmPrimitiveType.WAY);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.way, this.cmdNodes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractNodesCommand that = (AbstractNodesCommand)obj;
        return Objects.equals(this.way, that.way) && Objects.equals(this.cmdNodes, that.cmdNodes);
    }
}

