/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.tagplugins.jstl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Localizer;

public class Util {
    private static final String VALID_SCHEME_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int HIGHEST_SPECIAL = 62;
    private static final char[][] specialCharactersRepresentation = new char[63][];

    public static int getScope(String string) {
        int n = 1;
        if ("request".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("session".equalsIgnoreCase(string)) {
            n = 3;
        } else if ("application".equalsIgnoreCase(string)) {
            n = 4;
        }
        return n;
    }

    public static boolean isAbsoluteUrl(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (VALID_SCHEME_CHAR.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String getContentTypeAttribute(String string, String string2) {
        int n;
        int n2;
        int n3 = string.toUpperCase(Locale.ENGLISH).indexOf(string2.toUpperCase(Locale.ENGLISH));
        if (n3 == -1) {
            return null;
        }
        n3 += string2.length();
        if ((n3 = string.indexOf(61, n3)) == -1) {
            return null;
        }
        if ((string = string.substring(++n3).trim()).charAt(0) == '\"') {
            n2 = 1;
            n = string.indexOf(34, n2);
            if (n == -1) {
                return null;
            }
        } else {
            n2 = 0;
            n = string.indexOf(59);
            if (n == -1) {
                n = string.indexOf(32);
            }
            if (n == -1) {
                n = string.length();
            }
        }
        return string.substring(n2, n).trim();
    }

    public static String stripSession(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((n = stringBuilder.toString().indexOf(";" + Constants.SESSION_PARAMETER_NAME + "=")) != -1) {
            int n2 = stringBuilder.toString().indexOf(59, n + 1);
            if (n2 == -1) {
                n2 = stringBuilder.toString().indexOf(63, n + 1);
            }
            if (n2 == -1) {
                n2 = stringBuilder.length();
            }
            stringBuilder.delete(n, n2);
        }
        return stringBuilder.toString();
    }

    public static String escapeXml(String string) {
        String string2 = Util.escapeXml(string.toCharArray(), string.length());
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String escapeXml(char[] cArray, int n) {
        int n2 = 0;
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char[] cArray2;
            char c = cArray[i];
            if (c > '>' || (cArray2 = specialCharactersRepresentation[c]) == null) continue;
            if (n2 == 0) {
                stringBuilder = new StringBuilder(n + 5);
            }
            if (n2 < i) {
                stringBuilder.append(cArray, n2, i - n2);
            }
            n2 = i + 1;
            stringBuilder.append(cArray2);
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < n) {
            stringBuilder.append(cArray, n2, n - n2);
        }
        return stringBuilder.toString();
    }

    public static String resolveUrl(String string, String string2, PageContext pageContext) throws JspException {
        if (Util.isAbsoluteUrl(string)) {
            return string;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        if (string2 == null) {
            if (string.startsWith("/")) {
                return httpServletRequest.getContextPath() + string;
            }
            return string;
        }
        if (!string2.startsWith("/") || !string.startsWith("/")) {
            throw new JspTagException(Localizer.getMessage("jstl.urlMustStartWithSlash"));
        }
        if (string2.equals("/")) {
            return string;
        }
        return string2 + string;
    }

    static {
        Util.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        Util.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        Util.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        Util.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        Util.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }

    public static class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private final StringWriter sw = new StringWriter();
        private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        private final ServletOutputStream sos = new ServletOutputStream(){

            public void write(int n) throws IOException {
                bos.write(n);
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }
        };
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status = 200;
        private String charEncoding;

        public ImportResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public PrintWriter getWriter() {
            if (this.isStreamUsed) {
                throw new IllegalStateException(Localizer.getMessage("jstl.writerAfterOS"));
            }
            this.isWriterUsed = true;
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException(Localizer.getMessage("jstl.OSAfterWriter"));
            }
            this.isStreamUsed = true;
            return this.sos;
        }

        public void setContentType(String string) {
        }

        public void setLocale(Locale locale) {
        }

        public void setStatus(int n) {
            this.status = n;
        }

        public int getStatus() {
            return this.status;
        }

        public String getCharEncoding() {
            return this.charEncoding;
        }

        public void setCharEncoding(String string) {
            this.charEncoding = string;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                if (this.charEncoding != null && !this.charEncoding.isEmpty()) {
                    return this.bos.toString(this.charEncoding);
                }
                return this.bos.toString(Util.DEFAULT_ENCODING);
            }
            return "";
        }
    }
}

