# Stubs for docutils.io (Python 3.6)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from docutils import TransformSpec
from typing import Any, IO, List, Optional, Pattern, Tuple

__docformat__: str

class InputError(IOError): ...
class OutputError(IOError): ...

def check_encoding(stream: IO, encoding: str) -> Optional[bool]: ...

class Input(TransformSpec):
    component_type: str = ...
    default_source_path: str = ...
    encoding: str = ...
    error_handler: str = ...
    source: IO = ...
    source_path: str = ...
    successful_encoding: str = ...
    def __init__(self, source: Optional[Any] = ..., source_path: Optional[str] = ..., encoding: Optional[str] = ..., error_handler: str = ...) -> None: ...
    def read(self) -> str: ...
    def decode(self, data: str) -> str: ...
    coding_slug: Pattern[bytes] = ...
    byte_order_marks: Tuple[Tuple[bytes, str], ...] = ...
    def determine_encoding_from_data(self, data: str) -> str: ...

class Output(TransformSpec):
    component_type: str = ...
    default_destination_path: str = ...
    encoding: str = ...
    error_handler: str = ...
    destination: Any = ...
    destination_path: str = ...
    def __init__(self, destination: Optional[Any] = ..., destination_path: Optional[str] = ..., encoding: Optional[str] = ..., error_handler: str = ...) -> None: ...
    def write(self, data: str) -> str: ...
    def encode(self, data: str) -> str: ...

class FileInput(Input):
    autoclose: bool = ...
    source: IO = ...
    source_path: str = ...
    def __init__(self, source: Optional[IO] = ..., source_path: Optional[str] = ..., encoding: Optional[str] = ..., error_handler: str = ..., autoclose: bool = ..., mode: str = ..., **kwargs) -> None: ...
    def read(self) -> str: ...
    def readlines(self) -> List[str]: ...
    def close(self) -> None: ...

class FileOutput(Output):
    mode: str = ...
    opened: bool = ...
    autoclose: bool = ...
    destination: IO = ...
    destination_path: str = ...
    def __init__(self, destination: Optional[IO] = ..., destination_path: Optional[str] = ..., encoding: Optional[str] = ..., error_handler: str = ..., autoclose: bool = ..., handle_io_errors: Optional[Any] = ..., mode: Optional[str] = ...) -> None: ...
    def open(self) -> None: ...
    def write(self, data: str) -> str: ...
    def close(self) -> None: ...

class BinaryFileOutput(FileOutput):
    mode: str = ...

class StringInput(Input):
    default_source_path: str = ...
    def read(self) -> str: ...

class StringOutput(Output):
    default_destination_path: str = ...
    destination: str = ...
    def write(self, data: str) -> str: ...

class NullInput(Input):
    default_source_path: str = ...
    def read(self) -> str: ...

class NullOutput(Output):
    default_destination_path: str = ...
    def write(self, data: str) -> None: ...  # type: ignore

class DocTreeInput(Input):
    default_source_path: str = ...
    def read(self) -> str: ...
